#ifndef MBED_TOUCH_H
#define MBED_TOUCH_H

#include "mbed.h"
#include "SPI_TFT.h"

struct point{
       unsigned short x;
       unsigned short y;
       };


class touch_tft : public  SPI_TFT{
public:
    /** create a TFT with touch object connected to the pins:
     *
     * @param pin xp resistiv touch x+
     * @param pin xm resistiv touch x-
     * @param pin yp resistiv touch y+
     * @param pin ym resistiv touch y-
     * @param mosi,miso,sclk SPI connection to TFT
     * @param cs pin connected to CS of display
     * @param reset pin connected to RESET of display 
     * based on my SPI_TFT lib
     */
    touch_tft(PinName xp, PinName xm, PinName yp, PinName ym,PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset, PinName bk, const char* name ="TFT");
    
    /** calibrate the touch display
     *
     * User is asked to touch on two points on the screen
     */   
    void calibrate(void);
    
    /** read x and y analog samples
     *
     * @returns point(x,y)
     */
    point get_touch(void);
    
    /** calculate coord on screen
     *
     * @param a_point point(analog x, analog y)
     * @returns point(pixel x, pixel y)
     *
     */
    point to_pixel(point a_point);
    
    /** test if screen is touched
     * 
     * @param point analog x,y
     * @returns true is touched
     *
     */   
   point shared_pointer(unsigned int xo, unsigned int xf, unsigned int speed, unsigned repetitions);  
   
     
     
    bool is_touched(point a);    
    
protected:
    DigitalInOut _xp;
    DigitalInOut _xm;
    DigitalInOut _yp;
    DigitalInOut _ym;
    AnalogIn     _ax;
    AnalogIn     _ay;
    PinName xa;
    PinName ya;
    
    
    unsigned short x_a,y_a;
    unsigned short x_off,y_off;
    unsigned short pp_tx,pp_ty;
    
    
           
    };

#endif
