#include "touch_tft.h"
#include "mbed.h"
#include "Arial12x12.h"

#define  threshold 10000

touch_tft::touch_tft(PinName xp, PinName xm, PinName yp, PinName ym, PinName mosi, PinName miso, PinName sclk, PinName cs, PinName reset, PinName bk, const char *name)
        :_xp(xp),_xm(xm),_yp(yp),_ym(ym),_ax(xp),_ay(yp), SPI_TFT(mosi,miso,sclk,cs,reset,bk,name) {
    xa = xp;
    ya = yp;

}

/*  Esta clase trae el valor de p, siendo "p" un puntero
*
*/
point touch_tft::get_touch() {                      //puntero a touch clase get_touch
    unsigned short x1 = 0,x2 = 0, y1 = 0, y2 = 0;
    unsigned int s1 = 0,s2 = 0,d1 = 0 , d2 = 0;
    point p;

    do {
        /******************************************************************************************/
        // lee el voltaje en Y
        _xp.output();             //define salidas para x+ y x-
        _xm.output();
        switch (orientation) {
            case(0):                //En casos de orientacion 0 y 3
            case(3):                //pone en alto el x+
                _xp = 1;            //pone en bajo el x-
                _xm = 0;
                break;
            case(1):                //sino lo contrario
            case(2):
                _xp = 0;
                _xm = 1;
                break;
        }
        _ym.input();        // define y- como entrada para q sea "pasivo"
        AnalogIn Ay(ya);    // define constructor analogico como Ay para el pin y+
        // wait_us(10);
        y1 = Ay.read_u16(); // trae el voltaje en y1 desde y+ en el rango de 0 a 65535
        d1 = (y1 > y2)? (y1-y2) : (y2-y1);  //  //condiciona si y1 es mayor q y2 entonces opera d1=y1-y2 y si no es correcto entonces opera d1=y2-y1
        if (((y1 < 8000) && (d1 < 2000)) || ((y1 > 8000) && (d1 < 150))) s1 ++;    // si (y1<8000 Y d1<2000) O (y1>8000 Y d1<150)
        //  32768           8192                32768           336
        else {
            if (s1 > 0) s1=0;                                                      //entonces s1 = s1+1, sino pregunta si s1>0 entonces s1 = s1-1
        }
        y2 = y1;                                                                    //y2 es ahora igual a y1
        //debug
        //locate(1,7);
        //printf("d: %4d y: %5d s1: %4d",d1,y1,s1);
        /******************************************************************************************/
        // // lee el voltaje en X
        _yp.output();           //define salidas para y+ y y-
        _ym.output();
        switch (orientation) {
            case(0):                //En casos de orientacion 0 y 3
            case(1):                //pone en alto el x+
                _yp = 1;            //pone en bajo el x-
                _ym = 0;
                break;
            case(2):
            case(3):
                _yp = 0;            //sino lo contrario
                _ym = 1;
                break;
        }
        _xm.input();        // define x- como entrada para q sea "pasivo"
        AnalogIn Ax(xa);    // define constructor analogico como Ax para el pin x+
        // wait_us(0);
        x1 = Ax.read_u16(); // trae el voltaje en x1 desde x+ en el rango de 0 a 65535
        d2 = (x1 > x2)? (x1-x2) : (x2-x1);      //condiciona si x1 es mayor q x2 entonces opera d2=x1-x2 y si no es correcto entonces opera d2=x2-x1
        if (((x1 < 8000) && (d2 < 2000)) || ((x1 > 8000) && (d2 < 150))) s2 ++;     // si (x1<8000 Y d2<2000) O (x1>8000 Y d2<150)  //si(1+1)-> s2++
        //  32768           8192                32768           336
        else {
            if (s2 > 0) s2=0;                                                      //entonces s2 = s2+1, sino pregunta si s2>0 entonces s2 = s2-1
        }
        x2 = x1;                                                                    //y2 es ahora igual a y1
        // debug
        //locate(1,18);
        //printf("d: %4d x: %5d s2: %4d",d2,x1,s2);


        //wait_us(20);

    } while (s1 < 5 || s2 < 5); // read until we have three samples close together




    switch (orientation) {
        case(0):
        case(2):
            p.y = (x1+x2) / 2;  // promedio de dos muestras
            p.x = (y1+y2) / 2;
            break;
        case(1):
        case(3):
            p.x = (x1+x2) / 2;  // promedio de dos muestras
            p.y = (y1+y2) / 2;
            break;
    }

    return(p);
}

void touch_tft::calibrate(void) {
    int i;
    int a = 0,b = 0,c = 0, d = 0;
    
    //desde aki ocultar despues
/*
    int pos_x, pos_y;
    point p;
    
    set_font((unsigned char*)Arial12x12);  // select the font
    // get the center of the screen
    pos_x = (columns() / 2) + 2;
    pos_x = pos_x * font[1];
    pos_y = (rows() / 2) - 1;
    pos_y = pos_y * font[2];


    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

    //calcula primera posicion en extremo superior derecho
    cls();
    line(0,3,3,3,Orange);
    line(3,0,3,3,Orange);
    locate(pos_x- font[2]*3,pos_y);
    printf(" top ");
    locate(pos_x - font[2]*3 ,pos_y + font[2]);
    printf("right");

       for (i=0; i<5; i++) {
            while (p.y < threshold | p.x < threshold) // wait for TRUE touch      8192
            {
                p = get_touch();
            }
            a += p.x;
            b += p.y;
        }

    a = a/5;//55025;//a / 5;
    b = b/5;//9566;//b / 5;
        locate(1,36);
        printf("a: %4d b: %5d p.x: %4d p.y: %4d",a,b,p.x,p.y);//55405 9202 54669 9394  55069 9602 54957 10066 promedio a:55025
        wait(10);
    cls();
    locate(pos_x - font[2]*2,pos_y);
    printf("Good!");
    wait(0.5);

    while (p.y > 10000 | p.x > 10000) // wait for no touch
    {
        p = get_touch();
        locate(1,36);
        printf("p.x: %4d p.y: %4d",p.x,p.y);//55405 9202 54669 9394  55069 9602 54957 10066 promedio a:55025
    }

    //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
    //calcula segunda posicion en extremo inferior izquierdo
    cls();
    line(317,237,320,237,Orange);   // paint cross
    line(317,237,317,240,Orange);
    locate(pos_x- font[2]*3,pos_y);
    printf("booton");
    locate(pos_x- font[2]*3,pos_y + font[2]);
    printf(" left ");
    for (i=0; i<5; i++) {
        while (p.y < threshold | p.x < threshold) // wait for TRUE touch
        {
            p = get_touch();
        }
        c+= p.x;
        d+= p.y;
    }
    c = c/5;//9786;// c / 5;
    d = d/5;//55933;// d / 5;
        locate(1,66);
        printf("c: %4d d: %5d p.x: %4d p.y: %4d",c,d,p.x,p.y);// 9842 55965  9122 55901 9730 56541
        wait(10);
    cls();
    locate(pos_x - font[2]*2,pos_y);
    printf("Good!");
    wait(0.5);

    while (p.y > 10000 | p.x > 10000) // wait for no touch
    {
        p = get_touch();
        locate(1,36);
        printf("p.x: %4d p.y: %4d",p.x,p.y);//55405 9202 54669 9394  55069 9602 54957 10066 promedio a:55025
    }

*/    
///////////////////////////////////////////////////HASTA AKI LAS OPERACIONES////////////////////////////////////////////////////////
//Constantes para orientaciones 1 y 3:
    /*    
    a = 9850;
    b = 9314;//11650
    c = 55250;
    d = 54821;//55313
    */
//Constantes para orientaciones 0 y 2:    
        
    a = 9750;
    b = 8550;//11650
    c = 55250;
    d = 54521;//55313
    

    x_off = a;
    y_off = b;

    i = c-a;  // delta x               pp_tx = (c-a)/(w-6) = (54450-11600)/(320-6) = 42850/(314) = 136.46
    pp_tx = abs(i) / (width() - 6);

    i = d-b;  // delta y
    pp_ty = abs(i) / (height() - 4);
    //cls();
}


point touch_tft::to_pixel(point a_point) {
    point p;
    
    
    p.x = ((a_point.x - x_off) / pp_tx)+4;
    if (p.x > width()) p.x = width();
    p.y = (a_point.y - y_off) / pp_ty;
    if (p.y > height()) p.y = height();
    return (p);
}

bool touch_tft::is_touched(point a) {
    if (a.x > threshold & a.y > threshold) return(true);
    else return(false);
}

point touch_tft::shared_pointer(unsigned int xo,unsigned int xf, unsigned int speed, unsigned repetitions) {
    int Delta_X;
    point p;
    Delta_X = (xf-xo);
    windows (xo,0,xf,240);
    p = get_touch();
    if (is_touched(p)) {
        p = to_pixel(p);
        if (p.x <= xf && p.x >= xo){
            //if (p.x <= Delta_X)
            sharepoint(xo,320-xf,Delta_X,abs(Delta_X-p.x-1),speed,repetitions);
        }
        wait(0.125);
    }
    return (p);

}