#include "mbed.h"

#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <string.h>

#define LONG_CADENA 128

int main(void)
{
   time_t fecha;
   struct tm *temp;
   struct tm fecha_tm;
   char buffer[32];
   
   /* obtener fecha (time_t) */
   if ((fecha = time(NULL)) == (time_t) -1)
      return EXIT_FAILURE;
   
   /* obtener fecha (struct tm) */
   temp = localtime(&fecha);
   memcpy(&fecha_tm, temp, sizeof fecha_tm);
   
   /* imprimir mediante las funciones de la biblioteca time.h */
   printf("\nTime as a basic string with ctime(&fecha) = %s", ctime(&fecha));
   
   strftime(buffer, 32, "%a %b %d %H:%M:%S %Y\n", &fecha_tm);
   printf("Time using time.h with &fecha_tm: %s", buffer);
   
   printf("Time as a estructure  localtime(&fecha):\n");
   strftime(buffer,32,"%a %d %b %Y",localtime(&fecha));//Thu 20 Aug 2015
   printf("Fecha: Guayaquil %s\n", buffer);
   strftime(buffer,32,"%H:%M:%S, %p",localtime(&fecha));//Thu 20 Aug 2015
   printf("Hora:  %s\n\r", buffer);
   
   /* imprimir manualmente */
   printf("Estructure tm:\n\r");
   printf("tm_sec: %d\n\r",fecha_tm.tm_sec);
   printf("tm_min: %d\n\r",fecha_tm.tm_min);
   printf("tm_hour: %d\n\r",fecha_tm.tm_hour);
   printf("tm_mday: %d\n\r",fecha_tm.tm_mday);
   printf("tm_mon: %d\n\r",fecha_tm.tm_mon);
   printf("tm_year: %d\n\r",fecha_tm.tm_year+1900);
   printf("tm_wday: %d\n\r",fecha_tm.tm_wday);
   printf("tm_yday: %d\n\r",fecha_tm.tm_yday);
   printf("tm_isdst: %d\n\r",fecha_tm.tm_isdst);
   printf("\n\rExample:\n\r");
   printf("Time as ISO-8601:  %d%03d\n\r", fecha_tm.tm_year + 1900,fecha_tm.tm_yday);
   
   return EXIT_SUCCESS;
}

/*

ctime(&fecha):Thu Aug 20 19:58:42 2015
&fecha_tm: Thu Aug 20 19:58:42 2015
Time: 20 19:58:42 2015
Estructura tm:
tm_sec: 42      //Indica los segundos después de un minuto (o sea los segundos xD)
tm_min: 58      //Indica los minutos depués de una hora (los minutos vaya)
tm_hour: 19     //Indica el numero de horas despues de media noche  (lo que es la hora[0,23])
tm_mday: 20     //El dia del mes[1,31]
tm_mon: 7       //Meses que han pasado dede enero [0,11], por lo tanto Diciembre es el mes 11 y enero el mes 0
tm_year: 115    //Años desde 1900, si quieres saber el año actual sumas 1900
tm_wday: 4      //Dia de la semana, desde el domingo [0,6]
tm_yday: 231    //Dias desde el 1 de Enero [0,365]
tm_isdst: -1    //No se xDD, algo de daylight
Ejemplo:Tiempo segun ISO-8601:  2015231

*/