#include "Keyboard_Ts.h"

#define LENGTH_SIDE_SQUARE 80

KeyboardTs::KeyboardTs(unsigned char ucColumnNr){
    
    TouchScreen.Init(lcd.GetXSize(), lcd.GetYSize());
    square_x_pos = ucColumnNr * LENGTH_SIDE_SQUARE;
}

enum KeyboardState KeyboardTs::eRead(void){
    
    TouchScreen.GetState(&TSState);
    
    if(TSState.TouchDetected){        
        if((TSState.X > square_x_pos) && (TSState.X <= square_x_pos + LENGTH_SIDE_SQUARE)){
            
            if((TSState.Y > 0) && (TSState.Y <= LENGTH_SIDE_SQUARE)){
                return BUTTON_0;
            }
            else if((TSState.Y > LENGTH_SIDE_SQUARE) && (TSState.Y <= 2 * LENGTH_SIDE_SQUARE)){
                return BUTTON_1;
            }
            else if((TSState.Y > 2 * LENGTH_SIDE_SQUARE) && (TSState.Y <= 3 * LENGTH_SIDE_SQUARE)){
                return BUTTON_2;
            }
            else if((TSState.Y > 3 * LENGTH_SIDE_SQUARE) && (TSState.Y <= 4 * LENGTH_SIDE_SQUARE)){
                return BUTTON_3;
            }
        }
    }
    return NO_BUTTON_PRESSED;
}
