#include "mbed.h"
#include "LSM9DS1.h"
#include "motordriver.h"
#define PI 3.14159

//IMU used for monitoring orientation
// - wired using i2c in cookbook example here
//   https://developer.mbed.org/components/LSM9DS1-IMU/
LSM9DS1 IMU(p9, p10, 0xD6, 0x3C);
float initial_direction;

//wheel motors
Motor left(p21, p20, p23, 1);
Motor right(p26, p25, p24, 1);

//arm motor
Motor arm(p22, p7, p6,1);

//Color sensor, used to assist robot positioning
// - wired using i2c according to
//   https://developer.mbed.org/users/raj1995/notebook/adafruit-tcs34725-rgb-color-sensor/
I2C color_sensor(p28, p27); //pins for I2C communication (SDA, SCL)
int color_addr = 41 << 1;
int color_thresh = 4500;//threshold for green before it triggers
bool on_color = false;
DigitalOut green(LED1);

//pc serial connection, for debugging purposes
Serial pc(USBTX, USBRX);

//initialize and calibrate IMU

/*void initIMU(){
    IMU.begin();
    if (!IMU.begin()) {
        pc.printf("Failed to communicate with LSM9DS1.\n");
    }
    IMU.calibrate(1);
    IMU.calibrateMag(0);   
    
   initial_direction = getDirection();
}*/

//verify color sensor and initialize
void initColorSensor(){
    pc.baud(9600);
    
    // Connect to the Color sensor and verify
    color_sensor.frequency(200000);
    
    char id_regval[1] = {146};
    char data[1] = {0};
    color_sensor.write(color_addr,id_regval,1, true);
    color_sensor.read(color_addr,data,1,false);

    // Initialize color sensor
    
    char timing_register[2] = {129,0};
    color_sensor.write(color_addr,timing_register,2,false);
    
    char control_register[2] = {143,0};
    color_sensor.write(color_addr,control_register,2,false);
    
    char enable_register[2] = {128,3};
    color_sensor.write(color_addr,enable_register,2,false);   
}

void loadArm(){
    arm.speed(-.3);
    wait(2.7);
    arm.speed(0);        
}

//initialization for all components
void init(){
    //initIMU();    
    initColorSensor();
    loadArm();
}

// Sends a request to the server and waits for a path response
char* getPathFromServer(){
    //use wifi module here
    //https://developer.mbed.org/users/electromotivated/notebook/wifi-pid-redbot-robot-webserver/    
    char* path = "";
    return path;
}

//gets the orientation from imu
float getDirection(){
    float sum = 0;
    int target_samples = 100;
    int num_samples = 0;
    while(num_samples++ < target_samples){
        
        while(!IMU.magAvailable(X_AXIS));
            IMU.readMag();
        float my = IMU.calcMag(IMU.my);
        float mx = IMU.calcMag(IMU.mx);
        float dir;
        if (my == 0.0)
            dir = (mx < 0.0) ? 180.0 : 0.0;
        else
            dir = atan2(mx, my)*360.0/(2.0*PI);
        sum += dir;
    }
    
    return sum / target_samples;
}

float getRelativeDirection(){
    return getDirection() - initial_direction;    
}

//returns true when color is entered (subsequently returns false until color is exited and entered again)
bool colorEntered(){
    char red_reg[1] = {150};
    char red_data[2] = {0,0};
    color_sensor.write(color_addr,red_reg,1, true);
    color_sensor.read(color_addr,red_data,2, false);
    
    int red_value = ((int)red_data[1] << 8) | red_data[0];

    bool is_red = red_value > color_thresh;
    bool color_triggered = !on_color && is_red;
    on_color = is_red;
    //pc.printf("%d\r\n",red_value);
    return color_triggered;
}

//technologies for navigation may include
// - Line following https://www.sparkfun.com/products/11769
// - color sensor (indicates when end of movement is reached)
void moveForward(){}
void rotateLeft(){
    left.speed(0.3);
    right.speed(0.3);
    while(!colorEntered()) wait(.01);
}
void rotateRight(){}

//arem technology is yet to be determined, will probably involve adjusting a motor
void armUp(){
    arm.speed(.3);
    wait(2.5);
    arm.speed(0);            
}
void armDown(){
    arm.speed(-.3);
    wait(2.5);
    arm.speed(0);                
}

// Loops through path commands and executes each one sequentially
void executePath(char* path){
    int index = 0;
    while(path[index] != '\0'){
        switch(path[index]){
            case 'F': moveForward(); break;    
            case 'L': rotateLeft(); break;
            case 'R': rotateRight(); break;
            case 'U': armUp(); break;
            case 'D': armDown(); break;
        }    
    }
}

//main code
//- repeatedly listens for paths and then executes them
int main() {
    init();
    //rotateLeft();
    wait(5);
    while(true){
        armUp();
        wait(3);
        armDown();
        wait(3);
        /*while(!colorEntered()) wait(.1);
        green = 1;
        wait(5);
        green = 0;
        rotateLeft();
        left.speed(0);
        right.speed(0);
        wait(1);*/
        /*green = colorEntered();
        pc.printf("%f\r\n",getDirection());
        pc.printf("%f\r\n",getRelativeDirection());
        char* path = getPathFromServer(); */
        //executePath(path);
        //wait(.1);
    }
}
