//
// TFT_4DGL is a class to drive 4D Systems TFT touch screens
//
// Copyright (C) <2010> Stephane ROCHON <stephane.rochon at free.fr>
//
// TFT_4DGL is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// TFT_4DGL is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with TFT_4DGL.  If not, see <http://www.gnu.org/licenses/>.

#include "mbed.h"
#include "TFT_4DGL.h"
#include <stdarg.h>
#include <stdio.h>

// overwrite 4DGL library screen size settings in TFT_4DGL.h
#define SIZE_X  479
#define SIZE_Y  639
//

TFT_4DGL ecran(p9,p10,p11); // serial tx, serial rx, reset pin;


int outputrow = 1;
int j = 0;
char buffer[20480]; //working at 4608
char printbuf[256];
int linenum=1;

void myprintf(const char* format, ...) {
    char dest[256];
    if(j>80){
        j=0;
    }
    va_list argptr;
    va_start(argptr, format);
    vsprintf(dest, format, argptr);
    va_end(argptr);
    for ( int i = 0; i < 256; i++) {
        buffer[256*j+i]= dest[i];
    }
    j++;
    int linenum = j;

    for (int k = 0; k <256; k++) {
        printbuf[k] = buffer[256*(linenum-1)+k];
    }
    ecran.rectangle(0, 8*outputrow, 639, 8*outputrow+31, BLACK);
    ecran.text_string( dest, 0 , outputrow , FONT_8X8, WHITE);
    outputrow+= 4;
    if(outputrow>58){
        outputrow =1;
    }
}



int main() {
//    char s[500];
//    int x = 0, y = 0, status, xc = 0, yc = 0;

    ecran.baudrate(115200);
// added - Set Display to 640 by 480 mode
    ecran.display_control(0x0c, 0x01);
    for(int i=0; i < 300; i++){
        myprintf("This is line %i.Because printing to through the vga is slow, any prints off the screen will wrap around to the top of the screen and override the the existing text on the screen 1 line at a time. Therefore, the user has the ability to print infinitely.", i);
    }
}

/*
DigitalIn up(p22);
DigitalIn down(p21);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

void cursor() {
    DigitalIn up(p22);
    DigitalIn down(p21);
    DigitalOut led1(LED1);
    DigitalOut led2(LED2);
    DigitalOut led3(LED3);
    DigitalOut led4(LED4);
    while (1) {
        up.mode(PullUp);
        down.mode(PullUp);
        if (!up) {
            led1 = 1;
            if (linenum>0) {
                linenum--;
                for (int k = 0; k <256; k++) {
                    printbuf[k] = buffer[256*(linenum-1)+k];
                }
                ecran.rectangle(0, 0, 639, 59, BLACK);
                ecran.text_string( printbuf, 0 , 1 , FONT_8X8, WHITE);
            }
        }
        if (up) {
            led3 = 1;
            led1=0;
        }
        if (!down) {
            led2 = 1;
            if (linenum<j) {
                linenum++;
                for (int k = 0; k <256; k++) {
                    printbuf[k] = buffer[256*(linenum-1)+k];
                }
                ecran.rectangle(0, 0, 639, 59, BLACK);
                ecran.text_string( printbuf, 0 , 1 , FONT_8X8, WHITE);
            }
        }
        if (down) {
            led4 = 1;
            led2=0;
        }
    }
}
*/