#include "mbed.h"
#include <string>

#include "wifi.h"

#include "MQTTmbed.h"
#include "MQTTClient.h"
#include "MQTT_wifi.h"

#include "SimpleSpirit1.h"


/* Private defines -----------------------------------------------------------*/
#define WIFI_WRITE_TIMEOUT 10000
#define WIFI_READ_TIMEOUT  10000
#define CONNECTION_TRIAL_MAX          10


/* Private typedef------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
Serial pc(SERIAL_TX, SERIAL_RX);
uint8_t RemoteIP[] = {MBED_CONF_APP_SERVER_IP_1,MBED_CONF_APP_SERVER_IP_2,MBED_CONF_APP_SERVER_IP_3, MBED_CONF_APP_SERVER_IP_4};
uint8_t RxData [500];
char* modulename;
uint8_t TxData[] = "STM32 : Hello!\n";
uint16_t RxLen;
uint8_t  MAC_Addr[6];
uint8_t  IP_Addr[4];

void messageArrived(MQTT::MessageData& md)
{
    MQTT::Message &message = md.message;
    printf("message recieved\r\n");
}

static volatile bool tx_done_flag = false;
static void callback_func(int event)
{
    if (event == SimpleSpirit1::TX_DONE) {
        tx_done_flag = true;
    }
}

int main()
{


    pc.baud(115200);

    /*Initialize  WIFI module */
    if(WIFI_Init() ==  WIFI_STATUS_OK) {

        printf("> WIFI Module Initialized.\r\n");
        if(WIFI_GetMAC_Address(MAC_Addr) == WIFI_STATUS_OK) {
            printf("> es-wifi module MAC Address : %X:%X:%X:%X:%X:%X\r\n",
                   MAC_Addr[0],
                   MAC_Addr[1],
                   MAC_Addr[2],
                   MAC_Addr[3],
                   MAC_Addr[4],
                   MAC_Addr[5]);
        } else {
            printf("> ERROR : CANNOT get MAC address\r\n");
        }

        if( WIFI_Connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, WIFI_ECN_WPA2_PSK) == WIFI_STATUS_OK) {
            printf("> es-wifi module connected \r\n");
            if(WIFI_GetIP_Address(IP_Addr) == WIFI_STATUS_OK) {
                printf("> es-wifi module got IP Address : %d.%d.%d.%d\r\n",
                       IP_Addr[0],
                       IP_Addr[1],
                       IP_Addr[2],
                       IP_Addr[3]);

                printf("> Trying to connect to Server: %d.%d.%d.%d:8002 ...\r\n",
                       RemoteIP[0],
                       RemoteIP[1],
                       RemoteIP[2],
                       RemoteIP[3]);


                uint8_t  colca_addr[4];
                WIFI_GetHostAddress("colcaweb01.duckdns.org", colca_addr);

                printf("---- Colca IP address : %d.%d.%d.%d\r\n",
                       colca_addr[0],
                       colca_addr[1],
                       colca_addr[2],
                       colca_addr[3]);

                MQTT_wifi wf;
                int rc;
                printf("rc from connect:%d\r\n", rc);
                MQTT::Client<MQTT_wifi, Countdown> client(wf);
                wf.connect("colcaweb01.duckdns.org", 1883);

                MQTTPacket_connectData data = MQTTPacket_connectData_initializer;
                data.MQTTVersion = 3;
                data.clientID.cstring = "test-client";
                data.username.cstring = "test-user";
                data.password.cstring = "Tall5Duck";
                data.cleansession = 1;
                if ((rc = client.connect(data)) != 0)
                    printf("rc from MQTT connect is %d\r\n", rc);


                SimpleSpirit1 &subghz = SimpleSpirit1::CreateInstance(PC_12, PC_11, PC_10, PE_5, PB_5, PB_15);
                subghz.attach_irq_callback(callback_func);
                subghz.on();

                while(true) {

                    
                    char buf[SPIRIT1_MAX_PAYLOAD];
                    int size = subghz.read(buf, 25);
                    buf[size] = '\0';


                    rc = client.yield(5000);
                    if (rc) {
                        printf("Problem with client.yeild()\r\n");
                        client.connect(data);
                    } else {
                        printf("Still connected\r\n");
                    }

                    if (!strncmp(buf, "complete message", 16)) {
                        MQTT::Message message;
                        char msg_buf[100];
                        sprintf(msg_buf, buf);
                        message.qos = MQTT::QOS2;
                        message.retained = false;
                        message.dup = false;
                        message.payload = (void*)msg_buf;
                        message.payloadlen = strlen(msg_buf)+1;
                        client.publish("test/st/range", message);
                        printf("Received subghz message, sent mqtt message\r\n");
                        
                    }
                }
            } else {
                printf("> ERROR : es-wifi module CANNOT get IP address\n");
            }
        } else {
            printf("> ERROR : es-wifi module NOT connected\n");
        }
    } else {
        printf("> ERROR : WIFI Module cannot be initialized.\n");
    }
}
