#include <string>

#include "wifi.h"


class MQTT_wifi
{
public:
    MQTT_wifi() {
    }

    int connect(char* hostname, int port, int timeout=1000) {

        uint8_t  addr[4];
        if (WIFI_GetHostAddress(hostname, addr) != WIFI_STATUS_OK) {
            return -1;
        }

        if (WIFI_OpenClientConnection(0, WIFI_TCP_PROTOCOL, "TCP_CLIENT", addr, port, 100) != WIFI_STATUS_OK) {
            return -1;
        }

        socket = 0;
        return socket;
    }

    int read(unsigned char* buffer, int len, int timeout) {
        uint16_t read_len = -1;
        if(WIFI_ReceiveData(socket, buffer, len, &read_len, timeout) == WIFI_STATUS_OK) {
            return read_len;
        }

        return -1;
    }

    int write(unsigned char* buffer, int len, int timeout) {
        uint16_t sent_len = -1;
        if(WIFI_SendData(socket, buffer, len, &sent_len, timeout) == WIFI_STATUS_OK) {
            return sent_len;
        }
        
        return -1;
    }



private:
    int socket;

};