#include "mbed.h"
#include "Timer.h"
#include "uLCD_4DGL.h"
#include "Speaker.h"
#include "PinDetect.h"
#include <iostream>
#include <sstream>
#include <string>
#include "SDFileSystem.h"
using namespace std;
uLCD_4DGL uLCD(p28, p27, p29); // serial tx, serial rx, reset pin;
Timer t;
SDFileSystem sd(p5, p6, p7, p8, "sd");
DigitalIn rightButton(p16);
DigitalIn leftButton(p17);
DigitalIn reset(p18);
Speaker mySpeaker(p21);
unsigned int m_z=800,m_w=12345; //random number generator shamelessly stolen from https://developer.mbed.org/questions/2886/Why-is-the-rand-function-not-the-least-b/
unsigned int rnd()
{
    m_z = 36969 * (m_z & 65535) + (m_z >>16);
    m_w = 18000 * (m_w & 65535) + (m_w >>16);
    return ((m_z <<16) + m_w);
}
int generateSquare(int box[], int side) //makes a square shape
{
    int loc = abs(((int)rnd()))%18;
    while(box[loc]==1) {
        loc = abs((int)rnd())%18;
    }
    int col = loc%3;
    int row = (loc-col)/3;
    int y1 = (row*20);
    int x1 = (col*20);
    if(side==1) {
        x1 = x1 + 68;
    }
    int x2 = x1 + 19;
    int y2 = y1 + 19;
    int options[7] = {0xFFFFFF, 0xFF0000, 0x00FF00, 0x0000FF, 0xFF00FF, 0xFFFF00, 0x00FFFF};
    int color = options[abs((int)rnd())%7];

    uLCD.filled_rectangle(x1, y1, x2, y2, color);
    return loc;
}
int generateTriangle(int box[], int side) //makes a triangle shape
{
    int loc = abs(((int)rnd()))%18;
    while(box[loc]==1) {
        loc = abs((int)rnd())%18;
    }
    int col = loc%3;
    int row = (loc-col)/3;
    int y1 = (row*20)+1;
    int x1 = (col*20);
    if(side==1) {
        x1 = x1 + 68;
    }
    int x2 = x1 + 19;
    int y2 = y1;
    int y3 = y1 + 19;
    int x3 = x1 + 10;
    int options[7] = {0xFFFFFF, 0xFF0000, 0x00FF00, 0x0000FF, 0xFF00FF, 0xFFFF00, 0x00FFFF};
    int color = options[abs((int)rnd())%7];

    uLCD.triangle(x1, y1, x2, y2, x3, y3, color);
    return loc;
}
int generateCircle(int box[], int side) //makes a circle shape
{
    int loc = abs(((int)rnd()))%18;
    while(box[loc]==1) {
        loc = abs((int)rnd())%18;
    }
    int col = loc%3;
    int row = (loc-col)/3;
    int y = (row*20)+10;
    int x = (col*20)+10;
    if(side==1) {
        x = x + 68;
    }
    int options[7] = {0xFFFFFF, 0xFF0000, 0x00FF00, 0x0000FF, 0xFF00FF, 0xFFFF00, 0x00FFFF};
    int color = options[abs((int)rnd())%7];
    int size = (abs((int)rnd())%4)+5;
    uLCD.filled_circle(x, y, size, color);
    return loc;
}
string logData(int nT, int nC, int time, bool correct, FILE *fp) //logs data to file AND prints to screen
{
    std::ostringstream s;
    s << "Trial Number: " << nT << endl;
    if(correct) {
        s << "Lemur was correct" << endl;
    } else {
        s << "Lemur was incorrect\n";

    }
    s << "Fraction correct so far: " << nC << "/" << nT << endl;
    s << "Time elapsed during last trial, in ms: " << time << endl;
    fprintf(fp, s.str().c_str());
    return s.str();
}
int main()
{
    //startup screen
    uLCD.display_control(PORTRAIT);
    uLCD.cls();
    uLCD.printf("Hello Friendly    Lemur!");
    //super mario
    mySpeaker.PlayNote(660,.1,0.1);
    mySpeaker.PlayNote(0,.15,0.1);
    mySpeaker.PlayNote(660,.1,0.1);
    mySpeaker.PlayNote(0,.3,0.1);
    mySpeaker.PlayNote(660,.1,0.1);
    mySpeaker.PlayNote(0,.3,0.1);
    mySpeaker.PlayNote(510,.1,0.1);
    mySpeaker.PlayNote(0,.1,0.1);
    mySpeaker.PlayNote(660,.1,0.1);
    mySpeaker.PlayNote(0,.3,0.1);
    mySpeaker.PlayNote(770,.1,0.1);
    mySpeaker.PlayNote(0,.55,0.1);
    mySpeaker.PlayNote(380,.1,0.1);
    mySpeaker.PlayNote(0,.575,0.1);
    mySpeaker.PlayNote(510,.1,0.1);
    mySpeaker.PlayNote(0,.45,0.1);
    mySpeaker.PlayNote(380,.1,0.1);
    mySpeaker.PlayNote(0,.4,0.1);
    mySpeaker.PlayNote(320,.1,0.1);
    mySpeaker.PlayNote(0,.5,0.1);
    mySpeaker.PlayNote(440,.1,0.1);
    mySpeaker.PlayNote(0,.3,0.1);
    mySpeaker.PlayNote(480,.08,0.1);
    mySpeaker.PlayNote(0,.33,0.1);
    mySpeaker.PlayNote(450,.1,0.1);
    mySpeaker.PlayNote(0,.15,0.1);
    mySpeaker.PlayNote(430,.1,0.1);
    mySpeaker.PlayNote(0,.3,0.1);
    mySpeaker.PlayNote(380,.1,0.1);
    mySpeaker.PlayNote(0,.2,0.1);
    mySpeaker.PlayNote(660,.08,0.1);
    mySpeaker.PlayNote(0,.2,0.1);
    mySpeaker.PlayNote(760,.05,0.1);
    mySpeaker.PlayNote(0,.15,0.1);
    mySpeaker.PlayNote(860,.1,0.1);
    mySpeaker.PlayNote(0,.3,0.1);
    mySpeaker.PlayNote(700,.08,0.1);
    mySpeaker.PlayNote(0,.15,0.1);
    mySpeaker.PlayNote(760,.05,0.1);
    mySpeaker.PlayNote(0,.35,0.1);
    mySpeaker.PlayNote(660,.08,0.1);
    mySpeaker.PlayNote(0,.3,0.1);
    mySpeaker.PlayNote(520,.08,0.1);
    mySpeaker.PlayNote(0,.15,0.1);
    mySpeaker.PlayNote(580,.08,0.1);
    mySpeaker.PlayNote(0,.15,0.1);
    mySpeaker.PlayNote(480,.08,0.1);

    mkdir("/sd/mydir", 0777);
    FILE *fp = fopen("/sd/mydir/LemurResults.txt", "w");
    leftButton.mode(PullUp);
    rightButton.mode(PullUp);
    reset.mode(PullUp);             //some random variables that will be needed later (escaping from loops, keeping track of score, etc
    bool runTests = true;
    bool getoutoutside = false;
    bool getoutinside= false;
    bool isCorrect = false;
    int numCorrect = 0;
    int numTrials = 0;
    uLCD.baudrate(BAUD_3000000); //jack up baud rate to max for fast display
    wait(2);
//Set up initial conditions
    uLCD.background_color(BLACK);
    uLCD.cls();
//draw borders
    while(runTests) {
        numTrials++;
        uLCD.rectangle(0, 0, 59, 120, WHITE);
        uLCD.rectangle(68, 0, 127, 120, WHITE);         //basic setup completed every time
        int boxL[18] = {};
        int boxR[18] = {};
//15 is max number of circles
        int leftNum=(abs((int)rnd())%14)+1;
        int rightNum=(abs((int)rnd())%14)+1;
        while((leftNum==rightNum)||(leftNum==rightNum-1)||(leftNum==rightNum+1)||(leftNum==rightNum-2)||(leftNum==rightNum+2)) {
            rightNum=(abs((int)rnd())%14)+1;
        }
        bool answer = false; //false=left side less
        if(leftNum>rightNum) {
            answer = 1;   //true= right side less
        }
        for(int i = 0; i<leftNum; i++) {            //these loops place the already determined number of random shapes
            int choose = abs((int)rnd())%3;
            int newSpot = -1;
            if(choose==1)
                newSpot = generateSquare(boxL, 0);
            else if(choose==2)
                newSpot = generateTriangle(boxL, 0);
            else
                newSpot = generateCircle(boxL, 0);
            boxL[newSpot] = 1;
        }
        for(int i = 0; i<rightNum; i++) {
            int choose = abs((int)rnd())%3;
            int newSpot = -1;
            if(choose==1)
                newSpot = generateSquare(boxR, 1);
            else if(choose==2)
                newSpot = generateTriangle(boxR, 1);
            else
                newSpot = generateCircle(boxR, 1);
            boxR[newSpot] = 1;
        }
        while(!getoutinside) {          //lemur chooses which has fewer
            t.start();
            if(!leftButton) {
                getoutinside=true;
                if(!answer) {
                    numCorrect++;
                    isCorrect = true;
                }
                t.stop();

            }
            if(!rightButton) {
                getoutinside=true;
                if(answer) {
                    numCorrect++;
                    isCorrect = true;
                }
                t.stop();
            }
        }
        int time = t.read_ms();     //collect results, send it to logData function
        t.reset();
        getoutinside=false;
        wait(.25);
        uLCD.cls();
        string str = logData(numTrials, numCorrect, time, isCorrect, fp);
        uLCD.printf(str.c_str());
        while(!getoutoutside) {         //check if lemur is supposed to continue (third button)
            if(!reset) {
                getoutoutside=true;
                runTests = false;
            }
            if((!leftButton)||(!rightButton)) {
                getoutoutside=true;
            }
        }
        isCorrect = false;          //reset variables
        getoutoutside = false;
        uLCD.cls();
    }
    uLCD.printf("Goodbye, thanks for testing!");    //black screen, close file
    wait(4);
    uLCD.cls();
    fclose(fp);
}//end main
