/* FILE: tcp_task.h by Chu Van Thiem
*/
#ifndef __TCP_TASK_H__
#define __TCP_TASK_H__

#include "mbed.h"
#include "rtos.h"
#include "Queue.h"
#include "EthernetInterface.h"
#include "usb.h"

// Ethernet config
#define IP_ADDR "192.168.5.123"
#define IP_MASK "255.255.255.0"
#define GW_ADDR "192.168.5.1"
#define TCP_PORT 8001

// FSM states
#define STATE_IDLE  0
#define STATE_1     1
#define STATE_2     2
#define STATE_CMD   3
#define STATE_READ  4
#define STATE_WFILE 5
#define STATE_WDATA 6

// CMD
#define CMD_1     0xAA
#define CMD_2     0x55
#define CMD_PC    0x00
#define CMD_READ  0x00
#define CMD_WFILE 0x01
#define CMD_WDATA 0x02

// ACK
#define ACK_1     0xAA
#define ACK_2     0x55
#define ACK_MBED  0x01
#define ACK_READ  0x00
#define ACK_WFILE 0x01
#define ACK_WDATA 0x02
#define SPR_CHAR  0xFF

#define QUEUE_MAX_LEN 256
#define ACK_MAX_LEN   128
#define NAME_MAX_LEN  32
#define DATA_MAX_LEN  256

void tcp_thread(void const *args);
void cmd_thread(void const *args);

#endif
