/* FILE: usb.cpp by Chu Van Thiem
*/
#include "usb.h"

usb::usb(const char * rootdir) : USBHostMSD(rootdir)
{
    // Clear list of files
    filenames.clear();
}

void usb::listdir(const char *dir) {
    DIR *d;
    struct dirent *p;
    
    d = opendir(dir);
    if (d != NULL) {
        filenames.clear();
        while ((p = readdir(d)) != NULL) {
            //printf(" - %s\n", p->d_name);
            filenames.push_back(string(p->d_name));
        }
    } else {
        printf("Could not open directory!\n");
    }
    closedir(d);
}
