/* FILE: main.cpp by Chu Van Thiem + Sidik Soleman
*/
#include "mbed.h"
#include "rtos.h"
#include "EthernetInterface.h"
#include "USBHostMSD.h"
#include "usb.h"
#include "tcp_task.h"
#include "player.h"

extern Ticker ticker;
extern Ticker tickervolume;
extern volatile int joyvalue;

// Ethernet
EthernetInterface eth;

string songfile;
char* song;

volatile int cmd_en = 1;
volatile int play_en = 1;

int main() {
    int current = 0;
    // USB
    usb u("usb");
    while(!u.connect())
    {
        Thread::wait(5);
    }
    u.listdir("/");
    
    // Initialize ethernet interface
    eth.init(IP_ADDR, IP_MASK, GW_ADDR);
    eth.connect();
    //printf("Network setup completed!\n");
    
    // LCD
    welcome();
    /* print initiate */
    print(&(u.filenames), 0);
    /* reading the joystick value */
    ticker.attach(joystickcontrol, 0.004);
    /* reading the volume */
    tickervolume.attach(controlvolume, 0.004);
    
    // TCPIP thread
    Thread thread_tcp(tcp_thread, NULL, osPriorityBelowNormal, 512, NULL);
    Thread thread_cmd(cmd_thread, &u, osPriorityBelowNormal, 2048, NULL);
    
    while(1)
    {
        if (joyvalue == 1){
            if(u.filenames.size()>0){
                current = (current-1)%u.filenames.size();
                print(&(u.filenames),current);
            }
        }
        else if (joyvalue == 2){
            if(u.filenames.size()>0){
                current = (current+1)%u.filenames.size();
                print(&(u.filenames),current);
            }
        }
        else if (joyvalue == 3){
            if(u.filenames.size()>0){
                if (play_en)
                {
                    cmd_en = 0;
                    songfile = "/usb/";
                    songfile = songfile + u.filenames.at(current);
                    song = (char*)songfile.c_str();
                    play(song);
                    cmd_en = 1;
                }
            }
        }
        joyvalue = 0;
        Thread::wait(5);
    }
}
