/* FILE: player.cpp by Sidik Soleman
*/
#include "player.h"

C12832_LCD lcd;
AnalogOut DACout(p18);
/* joystick location */
DigitalIn Up(p15);
DigitalIn Down(p12);
DigitalIn Left(p13);
DigitalIn Right(p16);
DigitalIn Play(p14);
AnalogIn ain(p19);

Ticker ticker;
Ticker tickervolume;
int joyup=0,joydown=0,joyplay=0;
wave_player waver(&DACout);
volatile int joyvalue=0;
float aout = 0;
FILE *wave_file;

// Custom Function 
void play(char* song){
    wave_file=fopen(song,"r");
    waver.play(wave_file);
    fclose(wave_file);
}

void welcome(){
   lcd.cls();
   lcd.locate(15,0);
   lcd.printf("MBED Player"); 
   Thread::wait(1);
   lcd.cls();
}

void print(vector<string> *listoffile, int current){
    lcd.cls();
    int nsong = listoffile->size();
    lcd.locate(0,0);
    lcd.printf("Song Title (%d/%d)",(current+1),nsong);
    lcd.locate(0,9);
    lcd.printf("-------------------------------");
    if (nsong == 0){
       lcd.locate(0,15);
       lcd.printf("No File Song");
    } else {
        lcd.printf("> %s",(listoffile->at(current)).c_str());
    }
}

/* JoyValue = 1: up, 2: down, 3: play */
void joystickcontrol(){
    if (Up){
        if (joyup<NSAMPLE) joyup++;
        if (joyup==NSAMPLE){ joyvalue=1; joyup=0;}
    }
    if (Down){
        if (joydown<NSAMPLE) joydown++;
        if (joydown==NSAMPLE) { joyvalue=2; joydown = 0;}
    }
    if (Play){
        if (joyplay<NSAMPLE) joyplay++;
        if (joyplay==NSAMPLE) { joyvalue=3; joyplay=0;}
    }       
}

void controlvolume(){
    waver.volume = (float)ain;
}
