#include "MPU6050.h"
#include "MS5803.h"
#include "MS5837.h"
#include "IMU.h"
#include "HMC5883L.h"

MPU6050 mpu6050;
HMC5883L compass(I2C_SDA, I2C_SCL);
float depth, heading;
int16_t mag[3] = {0};


void sensor_init() {
    IMUinit(mpu6050);
    wait_ms(100);
    
    pc.printf("================================\n");
    pc.printf("Initialized begining readings\n");
    pc.printf("================================\n");
}

void sensor_update() {
    //IMU Update gets pitch and roll
    IMUUpdate(mpu6050);
        
    //gets heading
    compass.getXYZ(mag);
    
    float xh, yh;
    xh = mag[0]*cos(pitch*PI/180) + mag[1]*sin(roll*PI/180)*sin(pitch*PI/180) - mag[2]*cos(roll*PI/180)*sin(pitch*PI/180);
    yh = mag[1]*cos(roll*PI/180) + mag[2]*sin(roll*PI/180);
    heading = atan2(yh, xh) * 180/PI;
}

void sensor_msg() {
    //yaw,pitch,roll,raw heading, corrected heading, depth
    pc.printf("%f,%f,%f,%f,%f,%f\r\n", yaw, pitch, roll, compass.getHeadingXYDeg(), heading, depth);
}

void print_data() {
    pc.printf("================================\n");
    pc.printf("Yaw, pitch, roll: %f, %f, %f\n", yaw, pitch, roll);
    pc.printf("Depth: %f\n", depth);
    pc.printf("Heading w.o. tilt correction: %f\n", compass.getHeadingXYDeg());
    pc.printf("Heading with tilt correction: %f\n", heading);

}
