#include "my_tools.h"

using namespace std;

// TASK 1
// Read an analog input and return a float between 0 and 1
float   readAnalogInput(AnalogIn pin)
{
    return (pin.read());
}

// Delete first value of the given vector (the head)
void deleteFirstValueVec(vector<float> &vec)
{
    vec.erase(vec.begin());
}

// TASK 4 & 5
int monitorValue(float value, DigitalOut led, float thresholdValue)
{
    if (value > thresholdValue)
    {
        led = 1;
        return (1);
    }
    else
    {
        led = 0;
        return (0);
    }
}

// TASK 6
void writeOnLCD(WattBob_TextLCD &lcd, float odometer, float avg)
{
    static bool firstTime = true;
    /* We clear the LCD only the first time this function is run */
    if (firstTime)
    {
        /* Clear Display */
        lcd.cls();
        
        /* Print Distance */
        lcd.locate(0, 0);
        lcd.printf("D  km:  ");
        
        /* Print Avg Values of Speed */
        lcd.locate(1, 0);
        lcd.printf("S kmh: ");
        
        firstTime = false;        
    }
    
    /* Print Distance */
    lcd.locate(0, 7);
    lcd.printf("%.2f", odometer/1000);
    
    /* Print Avg Value of Speed */
    lcd.locate(1, 7);
    lcd.printf("%05.1f", avg*3.6);
}

// TASK 10
void updateLEDs(carStructure *myCar, bool right, bool left)
{
    if (right && left)
    {
        // Both ON - 2Hz
        myCar->p_rightLight->period_ms(500);
        myCar->p_rightLight->pulsewidth_ms(250);
        
        myCar->p_leftLight->period_ms(500);
        myCar->p_leftLight->pulsewidth_ms(250);
    }
    else if (right)
    {
        // Only right - 1Hz
        myCar->p_rightLight->period_ms(1000);
        myCar->p_rightLight->pulsewidth_ms(500);
        
        myCar->p_leftLight->period_ms(1000);
        myCar->p_leftLight->pulsewidth_ms(0);
    }
    else if (left)
    {
        // Only left - 1Hz
        myCar->p_rightLight->period_ms(1000);
        myCar->p_rightLight->pulsewidth_ms(0);
        
        myCar->p_leftLight->period_ms(1000);
        myCar->p_leftLight->pulsewidth_ms(500);
    }
    else
    {
        // Both OFF
        myCar->p_rightLight->period_ms(1000);
        myCar->p_rightLight->pulsewidth_ms(0.0);
        
        myCar->p_leftLight->period_ms(1000);
        myCar->p_leftLight->pulsewidth_ms(0.0);
    }
}
