#include <vector>
#include "mbed.h"
#include "my_structures.h"
#include "MCP23017.h"
#include "WattBob_TextLCD.h"

#pragma once
#ifndef __MY_TOOLS_H__
#define __MY_TOOLS_H__

/*******************************************************************************
 *                           FUNCTION TOOLS DECLARATION
 *                     To Simplify the code of the task themselves
 ******************************************************************************/

/** Read an analog input and return a float between 0 and 1
 *
 *  @param: pin [AnalogIn]
 *          Pin to read
 *
 *  @return: float between 0 and 1
 */
float   readAnalogInput(AnalogIn pin);


/** Delete the first value of the given vector
 *
 *  @param: &vec - Vector whose first value is deleted
 */
void    deleteFirstValueVec(vector<float> &vec);


/** Switch on a DigitalOut led if the given float value is above some threshold
 *
 *  @param: value [float]
 *          Checked Value
 *  @prama: led [DigitalOut]
 *          Output pin used to show if the value goes above the threshold
 *  @param: threshold [float]
 *          Threshold value use to switch on or or the DigitalOut pin
 *
 *  @return: int - 0 or 1, state of the DigitalOut pin
 */
int monitorValue(float value, DigitalOut led, float thresholdValue);


/** Write on the LCD the odometer and speed values
 *
 *  @param: &lcd [WattBob_TextLCD]
 *          Reference to the screen to use to display information
 *  @param: odometer [float]
 *          Travelled distance in m, displayed in km
 *  @param: avg [float]
 *          Last average speed computed in m/s. Displayed in km/h
 */
void writeOnLCD(WattBob_TextLCD &lcd, float odometer, float avg);


/** Update the PWM frequency of the right and left DigitalOut leds of the car
 *  based on the state of the given switch
 *
 *  @param: *myCar [carStructure]
 *          Main structure used in the program, used to access the right
 *          and left switch.
 *  @param: right [bool]
 *          State of the right switch
 *  @param: left [bool]
 *          State of the left switch.
 */
void updateLEDs(carStructure *myCar, bool right, bool left);

#endif /*! __MY__TOOLS_H__ */