#include "mbed.h"
DigitalOut led1(LED1);

#include "TinyGPSPlus.h"
TinyGPSPlus gps_parser;
static const int GPS_BAUD_RATE = 9600;
Serial gps(PA_15, PB_7);
char buf[128];

void callback() {
    char c = gps.getc();
    switch (c) {
        case '\n':
            if (gps_parser.satellites.isValid() && gps_parser.satellites.value() > 3 && gps_parser.hdop.hdop() > 0) {
                snprintf(buf, 128, "{\"lat\":%lf,\"lng\":%lf}", gps_parser.location.lat(), gps_parser.location.lng());
            } else {
                snprintf(buf, 128, "Satellites: %lu, time: %04d-%02d-%02dT%02d:%02d:%02d.%02d",
                gps_parser.satellites.value(), gps_parser.date.year(), gps_parser.date.month(), gps_parser.date.day(),
                gps_parser.time.hour(), gps_parser.time.minute(), gps_parser.time.second(), gps_parser.time.centisecond());
            }
            printf("%s\r\n", buf);
            break;
        default:
            gps_parser.encode(c);
            break;
    }
    led1 = !led1;
}

int main()
{
    gps.baud(GPS_BAUD_RATE);
    gps.format(8, Serial::None, 1);
    gps.attach(&callback, Serial::RxIrq);
    wait(osWaitForever);
}
