#include <mbed.h>

#include "ReceiverIR.h"
#include "TransmitterIR.h"
#define TEST_LOOP_BACK  0

ReceiverIR ir_rx(p2);
TransmitterIR ir_tx(p1);
// opravit čísla pinů

//Receiver
int receive(RemoteIR::Format *format, uint8_t *buf, int bufsiz, int timeout = 100)
{
    int cnt = 0;
    while (ir_rx.getState() != ReceiverIR::Received) {
        cnt++;
        if (timeout < cnt) {
            return -1;
        }
    }
    return ir_rx.getData(format, buf, bufsiz * 8);
}

//Transmitter
int transmit(RemoteIR::Format format, uint8_t *buf, int bitlength, int timeout = 100)
{
    int cnt = 0;
    while (ir_tx.getState() != TransmitterIR::Idle) {
        cnt++;
        if (timeout < cnt) {
            return -1;
        }
    }
    return ir_tx.setData(format, buf, bitlength);
}

int main(void) {
    
while (1)
{
    uint8_t buf1[32];
    uint8_t buf2[32];
    int bitlength1;
    int bitlength2;
    RemoteIR::Format format;

    memset(buf1, 0x00, sizeof(buf1));
    memset(buf2, 0x00, sizeof(buf2));

    {
        bitlength1 = receive(&format, buf1, sizeof(buf1));
        if (bitlength1 < 0) {
            continue;
        }
    }

#if TEST_LOOP_BACK
    wait_ms(100);

    {
        bitlength1 = transmit(format, buf1, bitlength1);
        if (bitlength1 < 0) {
            continue;
        }
    }

    wait_ms(100);

    {
        bitlength2 = receive(&format, buf2, sizeof(buf2));
        if (bitlength2 < 0) {
            continue;
        }
    }

    wait_ms(100);

    {
        for (int i = 0; i < sizeof(buf1); i++) {
            if (buf1[i] != buf2[i]) {
                wait(1);
                continue;
            }
        }
    }
#endif
}
}