#include "mbed.h"
#include "circularBuff.h"


// RECEPCIÓN Y TRANSMISIÓN DE DATSO A TRAVES DE DOS DISPOSITIVOS



# define BUFFER_SIZE 300  // DECLARAMOS EL TAMAÑO DEL BUFFER

Serial pc (USBTX,USBRX); // TX RX
Serial Placa2(p13 , p14);         // conexion serial puertos UART   PLACA DOS 

circ_buf_t BUFFER1;  // Estrucura buffer 1
circ_buf_t BUFFER2; // Estructura buffer 2


// Declaración de  variables volátiles
volatile bool BUFFER1CHECK = false;
volatile bool BUFFER2CHECK = false; //volátil: el campo puede ser modificado por varios subprocesos que se ejecutan al mismo tiempo

// Función de interrupción recepción de datos por serial pc
void pcRXInterrup(){  
    uint8_t data = pc.getc();
    if(data != NULL){
        circ_buf_put(&BUFFER1, data);
        
    }
    else
    {
    circ_buf_put(&BUFFER1, data);
    BUFFER1CHECK = true;  
    }
}


// subRUT transmisión puerto serial pc
void pcTXInterrup(){
    uint8_t dato = 0;
    circ_buf_get(&BUFFER1, &dato);
    pc.putc(dato);
}


// subRUT recepcion 2Mbed serial placa 2

void Placa2RXInterrup(){  
    uint8_t data = Placa2.getc();
    if(data != NULL)
    circ_buf_put(&BUFFER2, data); // Se guarda en el buffer el dato que llegan de la otra mbed
    else
    {
    circ_buf_put(&BUFFER2, data);
    BUFFER2CHECK = true;  
    }
    
    uint8_t dato2 = 0; // Visualizar en la pantalla el dato recibido de la otra mbed
    circ_buf_get(&BUFFER2, &dato2);
    pc.putc(dato2);
    
    
}



// subRUT trasnmision 2MBed serial placa 2

void Placa2TXInterrup(){
    uint8_t dato = Placa2.putc(pc.getc());
    circ_buf_put(&BUFFER2, dato);
}




int main() {
    
    
    pc.baud(115200); // velocidad baudios
 
    BUFFER1.buffer = (uint8_t*)malloc(BUFFER_SIZE);  // espacio de memoria para el buffer1
    BUFFER2.buffer = (uint8_t*)malloc(BUFFER_SIZE);  // espacio de memoria para el buffer2

    BUFFER1.size=BUFFER_SIZE; // inicializado buffer 1
    BUFFER2.size=BUFFER_SIZE; // inicializado buffer 2
    
    
     // interrupciones pc
    pc.attach(&pcRXInterrup,Serial::RxIrq);
    pc.attach(&pcTXInterrup,Serial::TxIrq);
   
    // interrupciones segunda placa
    Placa2.attach(Placa2RXInterrup,Serial::RxIrq);
    Placa2.attach(Placa2TXInterrup,Serial::TxIrq);
   
    
    
   
    while(1) {
        
        if(BUFFER1CHECK == true) // revision buffer preparado
            {
                uint8_t Z = NULL;
                do{                              // do while, primero ejecuta y luego revisa la condicion del while
                 circ_buf_get(&BUFFER1, &Z);    // Para visualizar en el CoolTerm
                 pc.putc(Z);
                }while(Z!=NULL);
                BUFFER1CHECK = false;
                
            }    
    
    }
}
