///Test of cheap 13.56 Mhz RFID-RC522 module from eBay
//This code is based on Martin Olejar's MFRC522 library. Minimal changes
//Adapted for Nucleo STM32 F401RE. Should work on other Nucleos too


//Connect as follows:
//RFID pins        ->  Nucleo header CN5 (Arduino-compatible header)
//----------------------------------------
//RFID IRQ=pin5    ->   Not used. Leave open
//RFID MISO=pin4   ->   Nucleo SPI_MISO=P12 adaptado para LPC
//RFID MOSI=pin3   ->   Nucleo SPI_MOSI=P11
//RFID SCK=pin2    ->   Nucleo SPI_SCK =P13
//RFID SDA=pin1    ->   Nucleo SPI_CS  =PB_6=D10   // para LPC P9
//RFID RST=pin7    ->   Nucleo         =PA_9=D8    // para LPC p28
//3.3V and Gnd to the respective pins


#include "mbed.h"
#include "MFRC522.h"
#include "EthernetInterface.h"

// Nucleo Pin for MFRC522 reset (pick another D pin if you need D8)
#define MF_RESET    p8


DigitalOut LedGreen(LED1);


//Serial connection to PC for output



//MFRC522    RfChip(SPI_MOSI, SPI_MISO, SPI_SCK, SPI_CS, MF_RESET);
MFRC522    RfChip(p11,p12,p13,p9, MF_RESET);

//********************************************************************


struct node {
    uint8_t data1;
    uint8_t data2;
    uint8_t data3;
    uint8_t data4;
    struct node *next;
};

// Se crean las estructuras front, rear y temp
struct node* front = NULL; // el puntento front de la estructura front se igual a null
struct node* rear = NULL;
struct node* temp; // nodo temporal
struct node* aux; // nodo auxiliar


void Insert(uint8_t val1, uint8_t val2, uint8_t val3, uint8_t val4)
{
    if (rear == NULL) {
        rear = new node; // se crea el nodo rear
        rear->next = NULL; // la direccion del siguiente nodo es a null 
        rear->data1 = val1; // se agregan los datos 
        rear->data2 = val2;
        rear->data3 = val3;
        rear->data4 = val4;
        front = rear; // se igual punto front a rear 
    }
    else{    
        aux = front;
        while (aux!= NULL) {
          if ((aux->data1==val1) && (aux->data2==val2) && (aux->data3==val3) &&(aux->data4==val4)){
              printf("ID already inserted \n\r");
              return;
          }
        temp = temp->next; 
       }
            
        temp=new node;
        rear->next = temp;
        temp->data1 = val1;
        temp->data2 = val2;
        temp->data3 = val3;
        temp->data4 = val4;
        temp->next = NULL;
        rear = temp;    
     }
}

void Display() {
 
    temp = front;
    if ((front == NULL) && (rear == NULL)) {
        printf("Queue is empty");
    return;
       }
    while (temp != NULL) {
        printf("Queue:\n");
        printf(" %02X ",temp->data1);
        printf(" %02X ",temp->data2);
        printf(" %02X ",temp->data3);
        printf(" %02X ",temp->data4);
        printf("\n");
        temp = temp->next;
        
       }
}


uint32_t UID[4]; 
EthernetInterface net;

int main(void)
{
    // Bring up the ethernet interface
    printf("Ethernet socket example\n");
    net.connect();

    // Show the network address
    SocketAddress a;
    net.get_ip_address(&a);
    printf("IP address: %s\n", a.get_ip_address() ? a.get_ip_address() : "None");

    // Open a socket on the network interface, and create a TCP connection to mbed.org
    TCPSocket socket;
    socket.open(&net);
    a="192.168.0.11";

    //net.gethostbyname("ifconfig.io", &a);
    a.set_port(80);
    socket.connect(a);
    
    
    printf("starting...\n");

    // Init. RC522 Chip
    RfChip.PCD_Init();

    while (true) {

        LedGreen = 1;

        // Look for new cards
        if ( ! RfChip.PICC_IsNewCardPresent()) {
            //wait_ms(500);
            ThisThread::sleep_for(500ms);
            continue;
        }

        // Select one of the cards
        if ( ! RfChip.PICC_ReadCardSerial()) {
            //wait_ms(500);
            ThisThread::sleep_for(500ms);
            continue;
        }

        LedGreen = 0;

        printf("New card UID to add: ");
        for (uint8_t i = 0; i < RfChip.uid.size; i++) {
            printf(" %02X",RfChip.uid.uidByte[i]);
            UID[i]=RfChip.uid.uidByte[i];
        }
        printf("\n\r");
        
        
        uint8_t a,b,c,d;
        a=RfChip.uid.uidByte[0];
        b=RfChip.uid.uidByte[1];
        c=RfChip.uid.uidByte[2];
        d=RfChip.uid.uidByte[3];
        Insert(a,b,c,d);
        Display(); 
        
        // Send a simple http request
        //char sbuffer[] = "Hola";
        //char sbuffer[] = "GET / HTTP/1.1\r\nHost: ifconfig.io\r\n\r\n";
        int scount = socket.send(UID,4);
        printf("sent %d [%p]\n",scount,UID);

        // Recieve a simple http response and print out the response line
        //char rbuffer[64];
        //int rcount = socket.recv(rbuffer, sizeof rbuffer);
        //printf("recv %d [%.*s]\n", rcount, strstr(rbuffer, "\r\n") - rbuffer, rbuffer);

        // Close the socket to return its memory and bring down the network interface
        //socket.close();

        // Bring down the ethernet interface
        //net.disconnect();
        printf("Done\n");
    }

}

//algoritmo de busqueda que encuentre un UID;

void print_dtb(UID* dtb,uint16_t N){
    for(int i=0; i<N; i++){
        for(int j=0; j<4;j++)
        printf("%02x ",dtb.bytes[j]);
        printf("\n");
        }
    }


void EEPROM4UID::updt_nuid(NUID num){ // parea actualizar los uids de la memoria
    uint8_t initUIDnum[]={num ->uid_hl[0],'\n'};
    writeStr_EEPROM(0x0000,initUIDnum);
    }