#include "EEPROM4UID.h"

EEPROM4UID::EEPROM4UID(PinName SDA,PinName SCL,uint16_t epraddr):eeprom(SDA,SCL){
    eeprom.frequency(400000);
    EPR_ADDR = epraddr;
} 

// Funciòn para escrbir en la EEPROM
int8_t EEPROM4UID::writeStr_EEPROM(uint16_t mem_addr, uint8_t* str){
    eeprom.start();
    int ack=eeprom.write(EPR_ADDR<<1);
    //printf("%d\n",ack);
    if(ack==1){
        eeprom.write(mem_addr>>8);//MSB de la posicion inicial a escribir
        eeprom.write(mem_addr);//LSB de la posicion inicial a escribir
        int i=0;
        while(str[i]!='\n'){
            eeprom.write(str[i]);
            i++;    
        }
        eeprom.stop();
        printf("escritura completa\n");
        return 1;    
    }
    
    else if(ack==0){
        printf("NACK");
        return -1;    
    }
    else if(ack==2){
        printf("TIMEOUT");
        return -2;    
    }
    return 0;
}

// Funcciòn para leer en la EPPROM
int8_t EEPROM4UID::readByte_EEPROM(uint16_t mem_addr, uint8_t* byte){
    //secuencia de lectura de 1 byte desde una direccion especifica de la eeprom
    eeprom.start();
    int ack=eeprom.write(EPR_ADDR<<1);
    if(ack==1){
        eeprom.write(mem_addr>>8);//MSB de la posicion a leer
        eeprom.write(mem_addr); //LSB de la posicion a leer
        eeprom.start();
        eeprom.write(EPR_ADDR<<1|0x01);
        *byte=eeprom.read(0);
        eeprom.stop(); 
        return 1;  
    }
    else if(ack==0){
        printf("NACK");
        return -1;    
    }
    else if(ack==2){
        printf("TIMEOUT");
        return -2;    
    }
  return 0;
}

// esta función actualiza el UID
void EEPROM4UID::updt_uidn(NUID &num){ // se declara dentro de la calse EEPROM4UID
    uint8_t initUIDnum[]={num.uidn_hl[1],num.uidn_hl[0],'\n'};
    writeStr_EEPROM(0x0000,initUIDnum); // se escribe desde la posición cero 
}
uint16_t EEPROM4UID::wrt_newUID(UID &newUID){
    uint8_t newUID_f[]={newUID.bytes[3],newUID.bytes[2],newUID.bytes[1],newUID.bytes[0],'\n'};
    writeStr_EEPROM(4*n.uidn+2,newUID_f);
    n.uidn++;
    this->updt_uidn(n); // actualizar el # de UIDS que hay en la memoria
    return n.uidn; // # de UIDS
    
    
}


uint16_t EEPROM4UID::read_uidn(){
    uint8_t NUIDH, NUIDL;
    readByte_EEPROM(0x0000,&NUIDH);//leer cantidad de uid parte alta
    readByte_EEPROM(0x0001,&NUIDL);// "  "                parte baja
    n.uidn= NUIDH<<8 | NUIDL; 
    return n.uidn; 
}

// Función que vuelca la bse de datos de la eeprom a al ram de la mbed
void EEPROM4UID::read_database(UID* dtbse){
    for(int i=0; i<n.uidn; i++){
        for(int j=0; j<4; j++){ // este for es porque se lee byte a byte
            readByte_EEPROM(i*4+j+2,&(dtbse[i].bytes[j]));  
            // Las primeras dos posiciones de la memoria están ocupadas por el # de UIDs    
            }
    }
}


/*
//comparar desde el key 
// ESTE ES EL ALGORITMO DE BUSQUEDA
void EEPROM4UID::busqueda(UID* dtse,uint16_t N,UID &IDbus){
    
 //   if(updt_uidn(n)> 0){  // updt es quien actualiza numero de UIDs
    for(int i=0; i<N; i++){    
            if (dtse[i].key == IDbus.key){
                printf("El UID a buscar se encuentra en la base de datos \n") ;
            }
            printf("El UID a buscar NO se encuentra en la base de datos \n")  ;  
    }
}
*/


