#include "mbed.h"
#ifndef EEPROM4UID_H
typedef union{ // creamos una estructura por facilidad
    uint8_t uidn_hl[2];
    uint16_t uidn;
    }NUID; // nombre de la estructura


typedef union{
    uint8_t bytes[4];
    uint32_t key;    
    
}UID;

// se hace como una clase   
class EEPROM4UID{
    public:
    EEPROM4UID (PinName SDA, PinName SCL, uint16_t epraddr); // constructor 
    int8_t writeStr_EEPROM(uint16_t mem_addr, uint8_t* str);
    int8_t readByte_EEPROM(uint16_t mem_addr, uint8_t* byte);
    uint16_t wrt_newUID(UID &newUID);//
    void updt_uidn(NUID &num); // actualizar el numero de IDs
    // le entra la nueva cantidad de UIDs 
    uint16_t read_uidn(); // función para leer los UIDS 
    void read_database(UID* dtbse);
    private: 
    I2C eeprom;
    NUID n;
    uint16_t EPR_ADDR;
    };
    
#endif