#include "mbed.h"

#ifndef Circular_buffer_H 
#define Circular_buffer_H


typedef struct {
    uint8_t *buffer;
    size_t head;
    size_t tail;
    size_t size; //of the buffer
} circ_buf_t;

// Función que resetea el buffer
int circ_buf_rst(circ_buf_t * cbuf);
// Función para agregar datos al buffer circular
int circ_buf_put(circ_buf_t * cbuf, uint8_t data);
// Función para obtener datos del buffer
int circ_buf_get(circ_buf_t * cbuf, uint8_t * data);
// Función para verificar si el buffer está vacío
bool circ_buf_empty(circ_buf_t cbuf);
// Función para verificar si el buffer está lleno
bool circ_buf_full(circ_buf_t cbuf);

#endif