#include "Circular_buffer.h"


// // Función que resetea el buffer
int circ_buf_rst(circ_buf_t * cbuf) 
{
    int r = -1;

    if(cbuf)
    {
        cbuf->head = 0;
        cbuf->tail = 0;
        r = 0;
    }

    return r;
}

// Función para verificar si el buffer está vacío
bool circ_buf_empty(circ_buf_t cbuf) // le entra la estructura, no el puntero
{
    return (cbuf.head == cbuf.tail); // cabeza igual a cola 
}


// Función para verificar si el buffer está lleno
bool circ_buf_full(circ_buf_t cbuf)
{
    return ((cbuf.head + 1) % cbuf.size) == cbuf.tail;
}

// Función para agregar datos al buffer circular
int circ_buf_put(circ_buf_t * cbuf, uint8_t data)
{
    int r = -1;

    if(cbuf)
    {
        cbuf->buffer[cbuf->head] = data;
        cbuf->head = (cbuf->head + 1) % cbuf->size;

        if(cbuf->head == cbuf->tail)
        {
            cbuf->tail = (cbuf->tail + 1) % cbuf->size;
        }

        r = 0;
    }

    return r;
}

// Función para obtener datos del buffer
int circ_buf_get(circ_buf_t * cbuf, uint8_t * data)
{
    int r = -1;

    if(cbuf && data && !circ_buf_empty(*cbuf))
    {
        *data = cbuf->buffer[cbuf->tail];
        cbuf->tail = (cbuf->tail + 1) % cbuf->size;

        r = 0;
    }

    return r;
}

