#include "bufferCircular.h"


//Funcion que permite resetear el buffer circular
int rstBuffer (bufferCircular* bufferC){
    int r = -1;
    
    if (bufferC)
    {
        bufferC->head = 0;
        bufferC->tail = 0;
        r = 0;   
    }   
    
    return r; 
}


//Funcion que permite colocar un dato en el buffer circular
int putBuffer (bufferCircular* bufferC, uint8_t dato){
    int r = -1;
    
    if (bufferC)
    {
        bufferC->buffer[bufferC->head] = dato;
        bufferC->head = (bufferC->head + 1) % bufferC->size;
        
        if(bufferC->head == bufferC->tail)
            bufferC->tail = (bufferC->tail + 1) % bufferC->size;
        
        r = 0;   
    }   
    
    return r; 
}

//Funcion que permite obtener los datos del buffer circular
int getBuffer (bufferCircular* bufferC, uint8_t* dato){
    
    int r = -1;
    
    if (bufferC && dato && emptyBuffer(*bufferC))
    {
        *dato = bufferC->buffer[bufferC->tail];
        bufferC->tail = (bufferC->tail + 1) % bufferC->size;
        
        r = 0;   
    }   
    
    return r; 
}


//Funcion que permite saber si el  buffer circular esta vacio
bool emptyBuffer (bufferCircular bufferC){
    
    bool empty;
    if (bufferC.head == bufferC.tail)
        empty = true;
    else
        empty = false;

    return empty;
}

//Funcion que permite saber si el  buffer circular esta lleno
bool fullBuffer (bufferCircular bufferC){
    
    bool full;
    if ((bufferC.head + 1 ) % bufferC.size  == bufferC.tail)
        full = true;
    else 
        full = false;

    return full;
}