#include "mbed.h"
#include "FastAnalogIn.h"
#include "WS2811.h"
#include "Colors.h"

unsigned const nLEDs = 30;//MAX_LEDS_PER_STRIP;
unsigned const DATA_OUT_PIN1 = 7; // PTC7

FastAnalogIn mic0(A0, 0);
FastAnalogIn mic1(A1, 0);
FastAnalogIn mic2(A2, 0);
Serial pc(USBTX, USBRX);

DigitalOut ledR(LED_RED);
DigitalOut ledG(LED_GREEN);
DigitalOut ledB(LED_BLUE);

static void showSolidColor(WS2811 &strip, uint8_t r, uint8_t g, uint8_t b)
{
    unsigned nLEDs = strip.numPixels();
    for (unsigned i = 0; i < nLEDs; i++) {
        strip.setPixelColor(i, r, g, b);
    }
    strip.show();
}

static void clearScreen(WS2811 &strip)
{
    unsigned nLEDs = strip.numPixels();
    for (unsigned i = 0; i < nLEDs; i++) {
        strip.setPixelColor(i, 0, 0, 0);
    }
    strip.show();
}
 
int main(void) {
    uint16_t i = 0;
    uint16_t buff0[500];
    uint16_t buff1[500];
    uint16_t buff2[500];
    char pc_read = 0;
    pc.baud(921600);
    ledR = ledG = ledB = 1;
    WS2811 lightStrip1(nLEDs, DATA_OUT_PIN1);
    lightStrip1.begin();

    while (true){
        pc_read = 0;
        for(i = 0; i < 251; i++){
            buff0[i] = int(1000*mic0.read());
            buff1[i] = int(1000*mic1.read());
            buff2[i] = int(1000*mic2.read());
        }
        for(i = 0; i < 251; i++){
            pc.printf("%d,%d,%d\n", buff0[i], buff1[i], buff2[i]);
        }

        while(pc_read != 'Y'){
            while(!pc.readable());
            pc_read = pc.getc();
            switch(pc_read){
                case 'Y':
                    pc.printf("Go\n");
                    break;
                                      
                case 'R':
                    ledR = 0;
                    ledG = 1;
                    ledB = 1;
                    break;
                
                case 'G':
                    ledR = 1;
                    ledG = 0;
                    ledB = 1;
                    break;

                case 'B':
                    ledR = 1;
                    ledG = 1;
                    ledB = 0;
                    break;
                
                case '1':
                    clearScreen(lightStrip1);
                    lightStrip1.setPixelColor(0, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(1, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(2, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(3, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(4, ledR*100, ledG*100, ledB*100);
                    break;
                
                case '2':
                    clearScreen(lightStrip1);
                    lightStrip1.setPixelColor(5, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(6, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(7, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(8, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(9, ledR*100, ledG*100, ledB*100);
                    break;
                    
                case '3':
                    clearScreen(lightStrip1);
                    lightStrip1.setPixelColor(10, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(11, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(12, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(13, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(14, ledR*100, ledG*100, ledB*100);
                    break;
                
                case '4':
                    clearScreen(lightStrip1);
                    lightStrip1.setPixelColor(15, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(16, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(17, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(18, ledR*100, ledG*100, ledB*100);                    
                    lightStrip1.setPixelColor(19, ledR*100, ledG*100, ledB*100);                    
                    break;                    
                
                case '5':
                    clearScreen(lightStrip1);
                    lightStrip1.setPixelColor(20, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(21, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(22, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(23, ledR*100, ledG*100, ledB*100);  
                    lightStrip1.setPixelColor(24, ledR*100, ledG*100, ledB*100);  
                    break;    
                
                case '6':
                    clearScreen(lightStrip1);
                    lightStrip1.setPixelColor(25, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(26, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(27, ledR*100, ledG*100, ledB*100);
                    lightStrip1.setPixelColor(28, ledR*100, ledG*100, ledB*100);  
                    lightStrip1.setPixelColor(29, ledR*100, ledG*100, ledB*100);  
                    break;    

                default:
                    break;
            
            }    
            lightStrip1.show();
            WS2811::startDMA();    
        }
    }
}