#ifndef VIEW_H
#define VIEW_H
#include "mbed.h"
#include "button.h"
#include "gauge.h"
#include "stm32746g_discovery_lcd.h"
#include <list>

#include <DHT22/DHT22.h>
#define SCREENWIDTH 480
#define SCREENHEIGHT 272

/*
    class View regrouppant les diferent element graphique et permettant le
    transfert des positions
*/


class View
{
public:
    View(int width = SCREENWIDTH, int height = SCREENHEIGHT, uint32_t bgColor = LCD_COLOR_WHITE);
    void            contain(int x, int y);
    void            draw();
    DHT22           *dht;
    void            updateGauge();
private :
    int16_t         m_width = SCREENWIDTH;
    int16_t         m_height = SCREENHEIGHT;
    uint32_t        m_bgColor = LCD_COLOR_WHITE;
    list <Button*>  m_buttonList;
    Gauge*          temperatureGauge;
    Gauge*          humidityGauge;
    void            setGaugeValue(float(DHT22::*funcGauge)(), Gauge* targetGauge);
    void            drawImage(int offsetX, int offsetY, int type);
    int             m_lastType = 0;
};

#endif