#include "view.h"
#include "stm32746g_discovery_lcd.h"
#include "mbed.h"
#include "button.h"
#include "gauge.h"
#include <DHT22/DHT22.h>
#include <list>
#include "pouce.h"
#include "PouceRouge.h"



View::View(int width, int height, uint32_t bgColor)
    : m_width(width), m_height(height), m_bgColor(bgColor)
{
    Button *butDefault = new Button(110, 200, 60);
    butDefault->setText("update");
    m_buttonList.push_back(butDefault);
    
    temperatureGauge = new Gauge;
    temperatureGauge->setText("Temperature");
    
    humidityGauge = new Gauge(150, 50);
    humidityGauge->setLimit(0, 100);
    humidityGauge->setColorType(1);
    humidityGauge->setText("Humidity");
    
    dht = new DHT22(D1);
    draw();
    drawImage(250, 40, 0);
}

void View::drawImage(int offsetX, int offsetY, int type)
{
    
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = nullptr;
    int h = 0;
    int w = 0;
    if (type)
    {
        dataPtr = (uint32_t*)Pouce.data;
        w = Pouce.width;
        h = Pouce.height;
    }
    else
    {
        dataPtr = (uint32_t*)PouceRouge.data;
        w = PouceRouge.width;
        h = PouceRouge.height;
    }
    while(y < h)
    {
        while(x < w)
        {
            uint32_t color = *dataPtr;
            if (!color)
                color = 0xffffffff;
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, color);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

void delay(int value)
{
    int delCnt = 0;
    while (delCnt < value)
    {
        delCnt ++;
        thread_sleep_for(1);
    }

}
static int testFunc(){
    return 5;
}

void View::setGaugeValue(float(DHT22::*funcGauge)(), Gauge* targetGauge)
{
    targetGauge->setValue((int)(dht->*funcGauge)());
}


void View::contain(int x, int y)
{
        int idBut = 0;
        for (Button *it : m_buttonList) {
        if (it->contain(x,y)) {
            if (idBut == 0)
            {
                updateGauge();
            }
            
        }
        idBut++;
    }
}

void View::updateGauge()
{
    setGaugeValue(&DHT22::getTemperature, temperatureGauge);
    setGaugeValue(&DHT22::getHumidity, humidityGauge);  
    int type = (dht->getHumidity() > 50) ? 1 : 0;
    if (m_lastType != type)
    {
        m_lastType = type;
        drawImage(250, 40, type);
    }
}

void View::draw()
{
    BSP_LCD_Clear(m_bgColor);
    for (Button *it : m_buttonList) {
        it->draw();
    }
    temperatureGauge->draw();
    humidityGauge->draw();
}