#include "mbed.h"
#include "button.h"
#include "view.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include <list>
#define SCREENWIDTH 480
#define SCREENHEIGHT 272
#include <DHT22/DHT22.h>

    uint8_t text[30];

void setBackgroundColor(uint32_t color)
{
    BSP_LCD_Clear(color);
}

void setHalfColor(uint32_t color0, uint32_t color1)
{
    BSP_LCD_Clear(color0);

    int x = SCREENWIDTH>>1;
    while (x < SCREENWIDTH) {
        int y = 0;
        while (y < SCREENHEIGHT) {
            BSP_LCD_DrawPixel(x, y, color1);
            y++;
        }
        x++;
    }
}

void updateButton()
{

}


int main()
{
    TS_StateTypeDef TS_State;
    uint16_t x, y;
    uint8_t status;
    uint8_t idx;
    uint8_t cleared = 0;
    uint8_t prev_nb_touches = 0;

    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);

    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) {
        BSP_LCD_Clear(LCD_COLOR_RED);
        BSP_LCD_SetBackColor(LCD_COLOR_RED);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
        while (1);
    } else {
        BSP_LCD_Clear(LCD_COLOR_GREEN);
        BSP_LCD_SetBackColor(LCD_COLOR_GREEN);
        BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT OK", CENTER_MODE);
    }

    HAL_Delay(100);
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetBackColor(LCD_COLOR_LIGHTCYAN);
    BSP_LCD_SetTextColor(LCD_COLOR_DARKBLUE);
    
    View v;
    while(1) {
        static int delayer = 0;
        
        delayer ++;
        if (delayer == 5000)
        {
            v.dht->read();
            v.updateGauge();
            delayer = 0;
        }

        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected) {
            cleared = 0;
            for (idx = 0; idx < TS_State.touchDetected; idx++) {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
                v.contain(x, y);
            }


        } else {
            if (!cleared) {
                //v.draw();
                cleared = 1;
            }
        }
    }
}
