#ifndef GAUGE_H
#define GAUGE_H
#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include <list>

class Gauge
{
public:
    Gauge(int x = 50, int y = 50, int width = 25, int height = 100, uint32_t bgColor = LCD_COLOR_LIGHTGRAY, uint32_t borderWidth = 1);
    void        setLimit(int low, int high);
    void        setText(const char *str);
    void        setColorType(uint8_t type);
    void        setValue(int value);

    uint32_t    getColor(uint32_t position);
    int8_t      getGaugePercentValue(int value);
    int8_t      getGaugePercentPosition(int value);
    int16_t     getValue(){return m_value;}
    
    void        draw();
    void        drawBorder();
    
    void        printValue();
    void        printText();
    void        printRange();

    int         strlen(uint8_t *str);

    void        contain(int x, int y);

private :
    uint32_t    m_bgColor = LCD_COLOR_LIGHTGRAY;
    uint32_t    m_borderColor = LCD_COLOR_GRAY;
    uint32_t    m_borderWidth = 1;
    int16_t     m_x = 0;
    int16_t     m_y = 0;
    int16_t     m_width = 25;
    int16_t     m_height = 150;
    int16_t     m_value = 20;
    int16_t     m_limLow = 10;
    int16_t     m_limHigh = 35;
    int16_t     m_delta = 0;
    int16_t     m_offset = 0;
    char        textValue[6];
    char        tValue[6];
    uint8_t     m_text[30];
    uint8_t     m_colorType = 0;
};

#endif