////////////// INCLUSION DES LIBRAIRIES (L1-L18)//////////////
#include "mbed.h"
#include "LEDMatrix.h"
#include "smallFont.h"
#include "stm32746g_discovery_ts.h"
#include "stm32746g_discovery_lcd.h"
#include "fleche.h"
#include "dessin.h"
#include "drapeau.h"
#include "croixbmp.h"
#include "gommebmp.h"
#include "allemagnebmp.h"
#include "belgiquebmp.h"
#include "beninbmp.h"
#include "francebmp.h"
#include "lgbpbmp.h"
#include "italiebmp.h"
/////////////////FIN INCLUSION DES LIBRAIRIES/////////////////



//////DEFINITION LARGEUR ET LONGUEURE DE LECRAN LED (L22-L25)//////
#define WIDTH   64
#define HEIGHT  32
//////// FIN DEFINITION LARGEUR ET LONGUEURE DE LECRAN LED ////////



//stb c'est le latch
// LEDMatrix    (a, b,  c, d,  oe_1, r1, r2, b1, b2, g1, g2, stb_1, clk_1);
LEDMatrix matrix(D1,D10,D0,D11,D7,   D5, D3, D4, D2, D8, D9, D12,   D13);
Ticker scanner;


// Display Buffer
uint8_t displaybuf[2][WIDTH *HEIGHT] = {
    0x00
};



/////////DEFINITION DES PROTOTYPES (L42-L46)/////////
void page_accueil(void);
void page_dessin(void);
void page_drapeau(void);
/////////FIN DE DEFINITION DES PROTOTYPES////////////


/////////DEFINITION DES VARIABLES GLOBALES (L49-L53)/////////
int xb=0, yb=0; // La valeur de x et y correspondante a l'ecran LCD
uint8_t text[30]; // SPRINTF
int p=0;// Pour le multicolor
/////////FIN DE DEFINITION DES VARIABLES GLOBALES ////////////



////////////////DEFINITION DES FONCTIONS DE DESSIN D'IMAGE (L57-L246)/////////////////////
//fleche
void drawImage_fleche(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)fleche.data;
    while(y < fleche.height) {
        while(x < fleche.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//belgique
void drawImage_belgique(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)belgiquebmp.data;
    while(y < belgiquebmp.height) {
        while(x < belgiquebmp.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//allemagne
void drawImage_allemagne(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)allemagnebmp.data;
    while(y < allemagnebmp.height) {
        while(x < allemagnebmp.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//benin
void drawImage_benin(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)beninbmp.data;
    while(y < beninbmp.height) {
        while(x < beninbmp.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//france
void drawImage_france(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)francebmp.data;
    while(y < francebmp.height) {
        while(x < francebmp.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//italie
void drawImage_italie(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)italiebmp.data;
    while(y < italiebmp.height) {
        while(x < italiebmp.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//lgbt
void drawImage_lgbt(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)lgbpbmp.data;
    while(y < lgbpbmp.height) {
        while(x < lgbpbmp.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//drapeau
void drawImage_drapeau(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)drapeau.data;
    while(y < drapeau.height) {
        while(x < drapeau.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}


//gomme
void drawImage_gomme(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)gommebmp.data;
    while(y < gommebmp.height) {
        while(x < gommebmp.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}

//croix
void drawImage_croix(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)croixbmp.data;
    while(y < croixbmp.height) {
        while(x < croixbmp.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}


//dessin
void drawImage_dessin(int offsetX, int offsetY)
{
    int x = 0;
    int y = 0;
    uint32_t* dataPtr = (uint32_t*)dessin.data;
    while(y < dessin.height) {
        while(x < dessin.width) {
            BSP_LCD_DrawPixel(x + offsetX, y + offsetY, *dataPtr);
            dataPtr++;
            x++;
        }
        x = 0;
        y++;
    }
}
////////////////FIN DEFINITION DES FONCTIONS DE DESSIN D'IMAGE (L57-L246)/////////////////////





/// FONCTION DE SCAN DE L'ECRAN LED//////
void scan()
{
    matrix.scan();
}
///FIN FONCTION DE SCAN DE L'ECRAN LED//////




///////////////////////// DEBUT DU MAIN (L262-L652)////////////////////////////////////////
int main()
{
    TS_StateTypeDef TS_State; // Definition de l'objet qui servira pour la detection de clic sur la STM32
    
    
    //Definition des variables locales au main
    uint16_t x, y;
    uint8_t status;
    uint8_t idx;
    int i,  c=1;
    int page = 0;   // La variable page défini la page sur laquelle on se trouve; page = 0 = page d'accueil; page = 1 = page dessin; page = 2 = page drapeau
    int couleur=7;//1 rouge; 2 vert; 3 jaune; 4 bleu; 5 violet; 6 cyan; 7 blanc
    
    
    ////////////////INITIALISATION DE LECRAN DE LA STM32//////////////
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    //////////////////////////////////////////////////////////////////


    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());               // Recupération d'un status
    if (status != TS_OK) {                                                      // SI LE STATUS N'EST PAS OK L'INIT FAIL
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);   
    } 
    else {                                                                      // SINON "INITIALISATION S'AFFICHE
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"INITIALISATION", CENTER_MODE);        
    }

    HAL_Delay(500);                         // Delais en ms
    BSP_LCD_SetFont(&Font12);               // Police d'écriture
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);  // Fond blanc
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);   // Coleur du texte bleu
    
    initFonts(); 

    matrix.begin((uint8_t *)displaybuf, WIDTH, HEIGHT);     // Sauv en mémoire la taille de la matrice LED
    
    scanner.attach(scan, 0.0003);   //Gère l'affiche sur la matrice LED
                                    //Un scan trop lent (>0.0009) provoque un effet de scintillement
                                    //Un scan trop rapide (<0.0001) provoque un effet d'allumage des LEDs qui sont sur la même ligne
    
    
    matrix.clear();                 //Fonction de nettoyage de la matrice, toutes les LEDs s'éteignent  
    
    
    // Drapeau de la France (sur la matrice)      
    matrix.drawRect(0,0,21,64,4);  
    matrix.drawRect(21,0,43,64,7);// Allumage d'une zone rectangulaire sur l'écran LED
    matrix.drawRect(43,0,64,64,1);   
    
    matrix.swap();
    while (!matrix.synchro());
    wait(1);
    matrix.clear();
        

    for (i=200; i>-400; i-=4) 
        {
            matrix.clear();
            matrix.drawCharString(i,0,"MATRICE LED LP SESAM",c,fonts[0]);   //Affichage de texte sur la matrice
            matrix.drawCharString(i,15,"CARPENTIER ANTOINE",c,fonts[0]);
            matrix.swap();
            wait(0.05);
            while (!matrix.synchro());
        }
        matrix.clear();
        
        BSP_LCD_Clear(LCD_COLOR_WHITE); // Effacage de l'ecran LCD
    
    
    ///////////// BOUCLE INFINI //////////////
    while (1) {  
        
        
        BSP_TS_GetState(&TS_State);     // Recuperation de l'état du tactile 
        
        if (TS_State.touchDetected)     // Si l'écran est touché
        {           
            x = TS_State.touchX[idx];   //Recuperation de la coordonné en x
            y = TS_State.touchY[idx];   //Recuperation de la coordonné en y
            xb = x/7.5;                 // xb fait correspondre la led aux pixels correspondant
            yb = y/7.5;                 // yb fait correspondre la led aux pixels correspondant
        }
    
    
        
        if (page == 0)
        {
             page_accueil();    // Par défault cette page est affiché
            }
               
        
        //VERS PAGE DESSIN
        if ((page == 0) && (x>= 10 && x<= 235) && (y>= 10 && y<= 235))  //Si nous sommes sur la page d'accueil et que nous cliquons dans la zone alors :
        {
            x=0;
            y=272;
            BSP_LCD_Clear(LCD_COLOR_WHITE); //On efface tout et on passe à la page suivante
            matrix.clear();
            matrix.swap();
            while (!matrix.synchro()); 
            page = 1;                       //Passage a la page dessin
            HAL_Delay(300);
        }
            
            
        // VERS DRAPEAU   
        if ((page==0)&&(x>=245 && x<=470)&&(y>= 10 && y<= 235))           //Si nous sommes sur la page d'accueil et que nous cliquons dans la zone alors :
        {
            x=0;
            y=0;
            BSP_LCD_Clear(LCD_COLOR_WHITE);     //On efface tout et on passe à la page suivante
            matrix.clear();
            matrix.swap();
            while (!matrix.synchro()); 
            page = 2;                           //Passage a la page drapeau
            HAL_Delay(100);
        }
        
        
        
        if(page == 1)               //SI NOUS SOMMES SUR LA PAGE DESSIN:
        {     
            page_dessin();          //Dessin des rectangles 
        
            matrix.swap();
            while (!matrix.synchro());   
        
            if (y<241)
            {
            
            
                if(couleur != 0)            //SI LA GOMME N'EST PAS SELECTIONNé
                {
                    BSP_LCD_DrawPixel(TS_State.touchX[0], TS_State.touchY[0], LCD_COLOR_ORANGE);       // Dessine sur l'ecran LCD
                    matrix.drawPoint(xb,yb,couleur);                                                   // Dessine sur la matrice LED aux coordonnées correspondantes à la où on touche sur la STM32
                                                                                                       // Taille du pointeur = 1x1
                }
                
                else                        //SI LA GOMME EST SELECTIONNé
                {
                    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                    BSP_LCD_FillRect(x-7.5,y-7.5,22.5,22.5);    //DESSINE DES CARRES BLANC SUR LECRAN LCD POUR EFFACER LA ZONE
                    
                    matrix.drawPoint(xb,yb,couleur);            // Couleur = 0 = ETEINT
                    matrix.drawPoint(xb+1,yb+1,couleur);
                    matrix.drawPoint(xb-1,yb-1,couleur);
                    matrix.drawPoint(xb+1,yb-1,couleur);
                    matrix.drawPoint(xb-1,yb+1,couleur);
                    matrix.drawPoint(xb-1,yb,couleur);
                    matrix.drawPoint(xb,yb-1,couleur);
                    matrix.drawPoint(xb+1,yb,couleur);
                    matrix.drawPoint(xb,yb+1,couleur);          // Taille du pointeur = 3x3 
                }
            
                matrix.swap();
                while (!matrix.synchro());
            }
            
         
        ////BARRE DES COMMANDE, CHOIX DES COULEURS DES LEDS, GOMME ... (L430-L536)/////
        if (x<=43 && x>=2 && y<=270 && y>=242 )
        {
            p=0;
            couleur = 1;    //ROUGE
        }
        
        if (x<=86 && x>=45 && y<=270 && y>=242 )
        {
            p=0;
            couleur = 2;    //VERT
        }
            
        if (x<=129 && x>=88 && y<=270 && y>=242 )
        {
            p=0;
            couleur = 4;    //BLEU
        }
        
        if (x<=172 && x>=131 && y<=270 && y>=242 )
        {
            p=0;
            couleur = 5;    //VIOLET
        }
        
        if (x<=215 && x>=174 && y<=270 && y>=242 )
        {
            p=0;
            couleur = 6;    //CYAN
        }
        
        if (x<=258 && x>=217 && y<=270 && y>=242 )
        {
            p=0;
            couleur = 3;    //JAUNE
        }
            
        if (x<=301 && x>=260 && y<=270 && y>=242 )
        {
            p=0;
            couleur = 7;    //BLANC
        }
        
        
        //CLIC MULTICOLOR     
        if (x<=344 && x>=303 && y<=270 && y>=242 )
        {
            p=1;     
        }
        
        //MULTICOLOR  
        if (p==1)
        {
            // DEFINITON DE ZONE ET DE COULEUR EN FONCTION 
            
            if (x<68 && y<91)couleur=7;
            if (x>=68 && x<136 && y<91)couleur=6;
            if (x>=136 && x<204 && y<91)couleur=5;
            if (x>=204 && x<272 && y<91)couleur=3;
            if (x>=272 && x<340 && y<91)couleur=4;
            if (x>=340 && x<408 && y<91)couleur=2;
            if (x>=408 && x<480 && y<91)couleur=1;   
            
            if (x<68   && y<91)couleur=1;
            if (x>=68  && x<136 && y<181 && y>90)couleur=2;
            if (x>=136 && x<204 && y<181 && y>90)couleur=3;
            if (x>=204 && x<272 && y<181 && y>90)couleur=4;
            if (x>=272 && x<340 && y<181 && y>90)couleur=5;
            if (x>=340 && x<408 && y<181 && y>90)couleur=6;
            if (x>=408 && x<480 && y<181 && y>90)couleur=7;  
            
            if (x<68   && y<91)couleur=5;
            if (x>=68  && x<136 && y>180)couleur=7;
            if (x>=136 && x<204 && y>180)couleur=2;
            if (x>=204 && x<272 && y>180)couleur=4;
            if (x>=272 && x<340 && y>180)couleur=1;
            if (x>=340 && x<408 && y>180)couleur=3;
            if (x>=408 && x<480 && y>180)couleur=6;  
        }
    
        //GOMME
        if (x<=396 && x>=355 && y<=267 && y>=254 )
        {
            p=0;
            couleur = 0;
        }
            
        //EFFACE TOUT
        if (x<=438 && x>=410 && y<=267 && y>=254 )
        {
            x=0;
            y=0;
            BSP_LCD_Clear(LCD_COLOR_WHITE);
            matrix.clear();
        }
        
        //RETOUR PAGE ACCUEIL 
        if ((x>= 458 && x<= 480) && (y>= 240 && y<= 270))
        {
            BSP_LCD_Clear(LCD_COLOR_WHITE);
            matrix.clear();
            matrix.swap();
            while (!matrix.synchro()); 
            x = 0;
            y = 0;
            page = 0;
        }
              
    }//FIN IF PAGE == 1 
    
        
        
        if (page == 2)  //PAGE DRAPEAU
        {
            page_drapeau();         //Affichage de la page drapeau
                           
            //HAUT GAUCHE
            if ((x>= 8 && x<= 236) && (y>= 29 && y<= 103))
            {
                x = 0;
                y = 0;
                //ALLEMAGNE
                matrix.clear();
                matrix.drawRect(0,10,64,21,3);
                matrix.drawRect(0,21,64,32,1); 
                matrix.swap();
                while (!matrix.synchro());
            }
                   
            // HAUT DROITE  
            else if ((x>= 244 && x<= 472) && (y>= 29 && y<= 103))
            {
                 x = 0;
                 y = 0;
                // BELGE
                matrix.clear();        
                matrix.drawRect(21,0,43,64,3);
                matrix.drawRect(43,0,64,64,1);
                matrix.swap();
                while (!matrix.synchro());  
            }
                    
            // MILIEU GAUCHE 
            else if ((x>= 8 && x<= 236) && (y>= 110 && y<= 184))
            {
                x = 0;
                y = 0;
                //BENIN
                matrix.clear();        
                matrix.drawRect(0,0,21,64,2);
                matrix.drawRect(21,0,64,16,3);
                matrix.drawRect(21,16,64,32,1);  
                matrix.swap();
                while (!matrix.synchro());
            }
    
            // MILIEU DROITE  
            else if ((x>= 244 && x<= 472) && (y>= 110 && y<= 184))
            {
                x = 0;
                y = 0;
                //MULTICOLOR
                matrix.clear();//1 rouge; 2 vert; 3 jaune; 4 bleu; 5 violet; 6 cyan; 7 blanc
                matrix.drawRect(0,0,64,4,7);
                matrix.drawRect(0,4,64,8,1);
                matrix.drawRect(0,8,64,12,3);
                matrix.drawRect(0,12,64,16,2);
                matrix.drawRect(0,16,64,20,4);
                matrix.drawRect(0,20,64,24,6);
                matrix.drawRect(0,24,64,28,5);
                matrix.drawRect(0,28,64,32,7);
                matrix.swap();
                while (!matrix.synchro());    
            }
                    
            // BAS GAUCHE    
            else if ((x>= 8 && x<= 236) && (y>= 192 && y<= 266))
            {
                x = 0;
                y = 0;
                //FRANCE
                matrix.clear();        
                matrix.drawRect(0,0,21,64,4);
                matrix.drawRect(21,0,43,64,7);
                matrix.drawRect(43,0,64,64,1);    
                matrix.swap();
                while (!matrix.synchro());
            }
                
                
            // BAS DROITE
            else if ((x>= 244 && x<= 472) && (y>= 192 && y<= 266))
            {
                 x = 0;
                 y = 0;
                 //ITALIE
                 matrix.clear();        
                 matrix.drawRect(0,0,21,64,2);
                 matrix.drawRect(21,0,43,64,7);
                 matrix.drawRect(43,0,64,64,1);  
                 matrix.swap();
                 while (!matrix.synchro());
            }
                
            if ((page==2)&&(x>= 458 && x<= 480) && (y>= 0 && y<= 22))
            {
                BSP_LCD_Clear(LCD_COLOR_WHITE);
                matrix.clear();
                matrix.swap();
                while (!matrix.synchro()); 
                x = 0;
                y = 0;
                page = 0;
            }     
            
        } // FIN IF == 2

    
    }// FIN WHILE
    

}// FIN MAIN
///////////////////////// FIN DU MAIN (L262-L652)////////////////////////////////////////






//////////////////// FONCTIONS PAGES (L659-L737) ///////////////////////////////////////////////////////
void page_accueil()
{
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK); //Couleur du texte
    BSP_LCD_DrawRect(10, 10, 225, 225);    //Bouton dessin 
    BSP_LCD_DrawRect(245, 10, 225, 225);   //Bouton drapeau
    
    sprintf((char*)text, "DESSIN");                                         //texte a ecrire
    BSP_LCD_DisplayStringAt(95, LINE(20), (uint8_t *)&text, LEFT_MODE);     //position du texte
    drawImage_dessin(15,15);                                                //fonction de dessin de l'image "dessin"
    
    sprintf((char*)text,"DRAPEAU");                                         //texte a ecrire
    BSP_LCD_DisplayStringAt(120, LINE(20), (uint8_t *)&text, CENTER_MODE);  //position du texte
    drawImage_drapeau(250, 15);                                             //fonction de dessin de l'image "drapeau"
    }   
    
    
void page_dessin()
{
        //AFFICHAGE DE LA BARRE DE COMMANDE 
        
        // ROUGE
        BSP_LCD_SetTextColor(LCD_COLOR_RED);
        BSP_LCD_FillRect(2,242,41, 28);
        //VERT
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_FillRect(45,242,41, 28);
        //BLEU
        BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
        BSP_LCD_FillRect(88,242,41, 28);
        //VIOLET
        BSP_LCD_SetTextColor(LCD_COLOR_MAGENTA);
        BSP_LCD_FillRect(131,242,41, 28);
        //CYAN
        BSP_LCD_SetTextColor(LCD_COLOR_CYAN);
        BSP_LCD_FillRect(174,242,41, 28);
        //JAUNE
        BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
        BSP_LCD_FillRect(217,242,41, 28);
        //BLANC
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
        BSP_LCD_DrawRect(260, 242, 41, 28);
        //MULTICOLOR
        BSP_LCD_SetTextColor(LCD_COLOR_RED);
        BSP_LCD_FillRect(303,242,10, 28);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_FillRect(314,242,10, 28);
        BSP_LCD_SetTextColor(LCD_COLOR_YELLOW);
        BSP_LCD_FillRect(325,242,10, 28);
        BSP_LCD_SetTextColor(LCD_COLOR_CYAN);
        BSP_LCD_FillRect(336,242,10, 28);
         
        drawImage_gomme(355,245); //GOMME
        drawImage_croix(410,243); //EFFACER TOUT
        drawImage_fleche(445,245); // Retour
                
        BSP_LCD_SetTextColor(LCD_COLOR_BLACK);  
        BSP_LCD_DrawHLine(0,240,480);        
    }

void page_drapeau()
{                                             
    BSP_LCD_DrawRect (8,  29, 228, 74);                 
    BSP_LCD_DrawRect (8,  110,228, 74);              
    BSP_LCD_DrawRect (8,  191,228, 73);    
    BSP_LCD_DrawRect (244,29, 228, 74); 
    BSP_LCD_DrawRect (244,110,228, 74);
    BSP_LCD_DrawRect (244,191,228, 73);
         
    drawImage_allemagne(10,31);            
    drawImage_belgique (246,31);
    drawImage_benin    (10,111);          
    drawImage_lgbt     (246,111);
    drawImage_france   (10,192);                      
    drawImage_italie   (246,192);                                        
    drawImage_fleche   (447,0);     // RETOUR
    
    }
//////////////////// FIN DES FONCTIONS PAGES (L659-L737) ///////////////////////////////////////////////////////





        
       
       










