#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"

Serial pc(USBTX, USBRX); // tx, rx
Serial ESP(A4, A5);  //

void Rx_interrupt();

const int buffer_size = 255;
char rx_buffer[buffer_size];
volatile int rx_in=0;
volatile int rx_out=0;
char chaine[50];
uint8_t text[30];
char recu[200];
char rx_line[80];
uint8_t status;
// main test program
int main() {
    pc.baud(9600);
    ESP.baud(9600);  
                
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_WHITE);

    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) { 
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
       
    } else {
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_DisplayStringAt(0, LINE(1), (uint8_t *)"Bienvenue chez", CENTER_MODE);
    }

    HAL_Delay(2000);
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);

  
    // Setup a serial interrupt function to receive data
    ESP.attach(&Rx_interrupt, Serial::RxIrq);

    while (1) {
        
    }
}


void Rx_interrupt() {
             
        for(int i =0; i<=200;i++)
        {
        chaine[i]=ESP.getc();
        sprintf((char*)text, "%s",chaine);
        BSP_LCD_DisplayStringAt(52, 10,(uint8_t *)&text, LEFT_MODE);  
        }
        
    return;
}
