#include "mbed.h"
#include "stm32746g_discovery_lcd.h"
#include "stm32746g_discovery_ts.h"
#include "button_group.hpp"
#include "draw.h"
#include "string.h"

//using namespace Mikami;
//TS_DISCO_F746NG ts_;
//LCD_DISCO_F746NG lcd_;
TS_StateTypeDef TS_State;

void Rx_interrupt();// Routine d'interruption
void page_commande(int *roro,int *bede,int *thethe,int *popo);
void page_liste(void);
void activ_bluetooth(void);
void page_accueil(void);
void aff(int *lc, int *nl);
void decrem(int *lc, int *nlc);
void increm (int *nlc);
void COMMANDE(int *L1, int *L2, int *L3, int *L4, int *L5, int *L6, int *n1, int *n2, int *n3, int *n4, int *n5, int *n6, int *rom, int *bede, int *thethe, int*poepoe);
int page = 2;
uint16_t x, y;
uint8_t text[30];
uint8_t n[30];
char chaine[100];
uint8_t status;
uint8_t idx;
uint8_t cleared = 0;
uint8_t prev_nb_touches = 0;
char ch;
int flagE=0, flagDP=0;
//float prix_total = 0;
//char buffer [50];
Serial pc(USBTX, USBRX); // tx, rx
Serial bluetooth1(D1, D0);  // module HC-06 branché à D1 (TX) et D2 (RX)
Serial ESP(A4, A5);  //Module ESP branché à A4 et A5
char recep[30];
 
// NOM DES LIVRES
// 0 = Hernani; 1 = Balzac; 2 = Cyrano; 3 = Blacksad; 4 = Boule&Bill; 5 = Cahier; 6 = Cid; 7 = Domjuan; 8 = Fleurs; 9 = gazette; 10 = NULL;
int lc1[6] = {2,7,5,3,8,1};
int lc2[6] = {1,2,3,10,10,10};
int lc3[6] = {0,4,7,9,2,10};
int lc4[6] = {8,7,6,5,4,3};
int lc5[6] = {8,0,6,1,5,3};
int lc6[6] = {8,7,6,5,10,10};

// Nombre de livres
int nlc1[6] = {7,8,1,2,5,4};
int nlc2[6] = {1,2,3,0,0,0};
int nlc3[6] = {7,8,1,2,5,0};
int nlc4[6] = {8,12,7,7,7,7};
int nlc5[6] = {10,10,10,10,10,10};
int nlc6[6] = {3,10,10,10,0,0};


//ROMAN   = BALZAC
//BD      = BLACKSAD, BOULE, GAZETTE
//THEATRE = HERNANI, CYRANO, CID, DOMJUAN
//POESIE  = CAHIER, FLEURS
int roman = 0;
int BD = 0;
int theatre = 0;
int poesie = 0;


int main()
{
    int c[6]={0,0,0,0,0,0}; //0 = a traiter 1 = en cours 2 = fait
    int commande = 6;
    bool debut = 0;
    bool ledbt=0;
    pc.baud(9600);
    bluetooth1.baud(38400);  
    ESP.baud(9600);  
    
    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    BSP_LCD_Clear(LCD_COLOR_WHITE);

    status = BSP_TS_Init(BSP_LCD_GetXSize(), BSP_LCD_GetYSize());
    if (status != TS_OK) { 
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_DisplayStringAt(0, LINE(5), (uint8_t *)"TOUCHSCREEN INIT FAIL", CENTER_MODE);
       
    } else {
        BSP_LCD_Clear(LCD_COLOR_WHITE);
        BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
        BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
        BSP_LCD_DisplayStringAt(0, LINE(1), (uint8_t *)"Bienvenue chez", CENTER_MODE);
        drawImage_Leroy_Merlin(90,80);
    }

    HAL_Delay(2000);
    BSP_LCD_Clear(LCD_COLOR_WHITE);
    
    BSP_LCD_SetFont(&Font12);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    
    ESP.attach(&Rx_interrupt, Serial::RxIrq);
    
    while(1) {
      
        // DETECTION CLICS
        BSP_TS_GetState(&TS_State);
        for (idx = 0; idx < TS_State.touchDetected; idx++) 
        {
                x = TS_State.touchX[idx];
                y = TS_State.touchY[idx];
            }
            
            
/////////////////// ACTIVATION BLUETOOTH ///////////////////////////////////////
                 
            if ((page==2)&&(x>=265 && x<=415)&&(y>= 50 && y<= 230))
            {
                activ_bluetooth();
                ledbt=1;
                x = 0;
                y = 0;
              }
           
            if(ledbt==0&&page==2)
            {
                BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
                sprintf((char*)text, "BT NON CONNECTE");
                BSP_LCD_DisplayStringAt(265, 250, (uint8_t *)&text, LEFT_MODE);
                BSP_LCD_SetTextColor(LCD_COLOR_RED);
                BSP_LCD_FillRect(391, 210, 24, 20);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                }
                
            if(ledbt==1&&page==2)
            { 
                BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
                sprintf((char*)text, "BT CONNECTE");
                BSP_LCD_DisplayStringAt(265, 250, (uint8_t *)&text, LEFT_MODE);
                BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
                BSP_LCD_FillRect(391, 210, 24, 20);
                BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                }    
                
////////////////////////////////////////////////////////////////////////////////
            
            
        ////////////////CLICS////////////////
            
        // PAGE COMMANDE VERS PAGE D'ACCUEIL
        if ((page == 0) && (x>= 458 && x<= 480) && (y>= 0 && y<= 22))
        {
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             x = 0;
             y = 0;
             page = 2;
             page_accueil();
             HAL_Delay(300);
            }
        
        //PAGE ACCUEIL VERS PAGE COMMANDE
        if ((page == 2) && (x>= 65 && x<= 215) && (y>= 60 && y<= 240))
        {
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             x = 0;
             y = 0;
             page = 0;
             HAL_Delay(300);
            }
            
            
        // PAGE LISTE VERS PAGE COMMANDE 
        if ((page == 1) && (x>= 458 && x<= 480) && (y>= 0 && y<= 22))
        {
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             x = 0;
             y = 0;
             page = 0;
             commande = 6;
             HAL_Delay(300);
            }     
            
        
        
       //PAGE COMMANDE
       // HAUT GAUCHE  
        else if ((page == 0) && (x>= 8 && x<= 236) && (y>= 29 && y<= 103))
        {
             x = 0;
             y = 0;
             page = 1;
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             page_liste();
             commande = 0;
             HAL_Delay(200);
            }
           
        // HAUT DROITE  
        else if ((page == 0) && (x>= 244 && x<= 472) && (y>= 29 && y<= 103))
        {
             x = 0;
             y = 0;
             page = 1;
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             page_liste();
             commande = 1;
             HAL_Delay(200);
            }
            
        // MILIEU GAUCHE 
        else if ((page == 0) && (x>= 8 && x<= 236) && (y>= 110 && y<= 184))
        {
             x = 0;
             y = 0;
             page = 1;
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             page_liste();
             commande = 2;
             HAL_Delay(200);
            }

        // MILIEU DROITE  
        else if ((page == 0) && (x>= 244 && x<= 472) && (y>= 110 && y<= 184))
        {
             x = 0;
             y = 0;
             page = 1;
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             page_liste();
             commande = 3;
             HAL_Delay(200);
            }
            
        // BAS GAUCHE    
        else if ((page == 0) && (x>= 8 && x<= 236) && (y>= 192 && y<= 266))
        {
             x = 0;
             y = 0;
             page = 1;
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             page_liste();
             commande = 4;
             HAL_Delay(200);
            }
            
            
        // BAS DROITE
        else if ((page == 0) && (x>= 244 && x<= 472) && (y>= 192 && y<= 266))
        {
             x = 0;
             y = 0;
             page = 1;
             BSP_LCD_Clear(LCD_COLOR_WHITE);
             page_liste();
             commande = 5;
             HAL_Delay(200);
            }
            
        else if (page == 0) 
        {
             page_commande(&roman,&BD,&theatre,&poesie);
             // AFFICHAGE DES PASTILLES DE COULEURS
            for (int i=0;i<6;i++)
            {
                if(c[i] == 0){
                    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                    BSP_LCD_FillRect(211+(236*(i%2)), 80+(80*(i/2)), 25, 24);
                    }
                else if(c[i] == 1){
                    BSP_LCD_SetTextColor(LCD_COLOR_RED);
                   BSP_LCD_FillRect(211+(236*(i%2)), 80+(80*(i/2)), 25, 24);  
                    }
                else if(c[i] == 2){
                    BSP_LCD_SetTextColor(LCD_COLOR_GREEN);
                    BSP_LCD_FillRect(211+(236*(i%2)), 80+(80*(i/2)), 25, 24);
                    }
            }
        }
        
        else if (page == 1)
        {
             page_liste();
            }
            
        else if (page == 2)
        {
             page_accueil();
            }
       
    
    
    switch (commande)  
    {

    case 0:
        aff(lc1,nlc1);          
        if ( c[0] == 0 )
        {
              if (debut == 0)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "CHOISIR LA COMMANDE");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
              if (debut == 1)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "AUTRE COMMANDE EN COURS");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
                
              if ( (debut==0) && (x>= 8 && x<= 236) && (y>= 220 && y<= 265) )
              {
                    x=0;
                    y=0;
                    c[0]= 1 ;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
              }
        }
            
        if ( c[0] == 1 )
        {
            debut=1;
            sprintf((char*)text, "COMMANDE EN COURS");
            BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
            BSP_LCD_DrawRect(244, 220, 228, 45);
            sprintf((char*)text, "FIN DE COMMANDE");
            BSP_LCD_DisplayStringAt(300, 242, (uint8_t *)&text, LEFT_MODE);
                
            if(bluetooth1.readable()) 
            {
                ch=bluetooth1.getc();
                decrem(lc1,nlc1);
               }     
                    
           increm(nlc1);
           
            
            
            if ( (x>= 244 && x<= 472) && (y>= 220 && y<= 265) )  //Fin de commande
               {
                    x=0;
                    y=0;
                    c[0]= 2 ;
                    x=475;
                    y=5;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
                }
        }
            
        if ( c[0] == 2 )
        {
                debut = 0;
                sprintf((char*)text, "COMMANDE TRAITEE");
                BSP_LCD_DisplayStringAt(0,260, (uint8_t *)&text, CENTER_MODE);
        }
        break;
        
      case 1:
        aff(lc2,nlc2);          
        if ( c[1] == 0 )
        {
              if (debut == 0)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "CHOISIR LA COMMANDE");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
              if (debut == 1)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "AUTRE COMMANDE EN COURS");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
                
              if ( (debut==0) && (x>= 8 && x<= 236) && (y>= 220 && y<= 265) )
              {
                    x=0;
                    y=0;
                    c[1]= 1 ;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
              }
        }
            
        if ( c[1] == 1 )
        {
            debut=1;
            sprintf((char*)text, "COMMANDE EN COURS");
            BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
            BSP_LCD_DrawRect(244, 220, 228, 45);
            sprintf((char*)text, "FIN DE COMMANDE");
            BSP_LCD_DisplayStringAt(300, 242, (uint8_t *)&text, LEFT_MODE);
                
            if(bluetooth1.readable()) 
            {
                ch=bluetooth1.getc();
                decrem(lc2,nlc2);
               }     
                    
           increm(nlc2);
           
            
            
            if ( (x>= 244 && x<= 472) && (y>= 220 && y<= 265) )  //Fin de commande
               {
                    x=0;
                    y=0;
                    c[1]= 2 ;
                    x=475;
                    y=5;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
                }
        }
            
        if ( c[1] == 2 )
        {
                debut = 0;
                sprintf((char*)text, "COMMANDE TRAITEE");
                BSP_LCD_DisplayStringAt(0,260, (uint8_t *)&text, CENTER_MODE);
        }
        break;
        
      case 2:
        aff(lc3,nlc3);          
        if ( c[2] == 0 )
        {
              if (debut == 0)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "CHOISIR LA COMMANDE");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
              if (debut == 1)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "AUTRE COMMANDE EN COURS");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
                
              if ( (debut==0) && (x>= 8 && x<= 236) && (y>= 220 && y<= 265) )
              {
                    x=0;
                    y=0;
                    c[2]= 1 ;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
              }
        }
            
        if ( c[2] == 1 )
        {
            debut=1;
            sprintf((char*)text, "COMMANDE EN COURS");
            BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
            BSP_LCD_DrawRect(244, 220, 228, 45);
            sprintf((char*)text, "FIN DE COMMANDE");
            BSP_LCD_DisplayStringAt(300, 242, (uint8_t *)&text, LEFT_MODE);
                
            if(bluetooth1.readable()) 
            {
                ch=bluetooth1.getc();
                decrem(lc3,nlc3);
               }     
                    
           increm(nlc3);
           
            
            
            if ( (x>= 244 && x<= 472) && (y>= 220 && y<= 265) )  //Fin de commande
               {
                    x=0;
                    y=0;
                    c[2]= 2 ;
                    x=475;
                    y=5;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
                }
        }
            
        if ( c[2] == 2 )
        {
                debut = 0;
                sprintf((char*)text, "COMMANDE TRAITEE");
                BSP_LCD_DisplayStringAt(0,260, (uint8_t *)&text, CENTER_MODE);
        }
        break;
    
      case 3:
        aff(lc4,nlc4);          
        if ( c[3] == 0 )
        {
              if (debut == 0)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "CHOISIR LA COMMANDE");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
              if (debut == 1)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "AUTRE COMMANDE EN COURS");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
                
              if ( (debut==0) && (x>= 8 && x<= 236) && (y>= 220 && y<= 265) )
              {
                    x=0;
                    y=0;
                    c[3]= 1 ;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
              }
        }
            
        if ( c[3] == 1 )
        {
            debut=1;
            sprintf((char*)text, "COMMANDE EN COURS");
            BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
            BSP_LCD_DrawRect(244, 220, 228, 45);
            sprintf((char*)text, "FIN DE COMMANDE");
            BSP_LCD_DisplayStringAt(300, 242, (uint8_t *)&text, LEFT_MODE);
                
            if(bluetooth1.readable()) 
            {
                ch=bluetooth1.getc();
                decrem(lc4,nlc4);
               }     
                    
           increm(nlc4);
           
            
            
            if ( (x>= 244 && x<= 472) && (y>= 220 && y<= 265) )  //Fin de commande
               {
                    x=0;
                    y=0;
                    c[3]= 2 ;
                    x=475;
                    y=5;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
                }
        }
            
        if ( c[3] == 2 )
        {
                debut = 0;
                sprintf((char*)text, "COMMANDE TRAITEE");
                BSP_LCD_DisplayStringAt(0,260, (uint8_t *)&text, CENTER_MODE);
        }
        break;
    
      case 4:
        aff(lc5,nlc5);          
        if ( c[4] == 0 )
        {
              if (debut == 0)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "CHOISIR LA COMMANDE");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
              if (debut == 1)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "AUTRE COMMANDE EN COURS");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
                
              if ( (debut==0) && (x>= 8 && x<= 236) && (y>= 220 && y<= 265) )
              {
                    x=0;
                    y=0;
                    c[4]= 1 ;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
              }
        }
            
        if ( c[4] == 1 )
        {
            debut=1;
            sprintf((char*)text, "COMMANDE EN COURS");
            BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
            BSP_LCD_DrawRect(244, 220, 228, 45);
            sprintf((char*)text, "FIN DE COMMANDE");
            BSP_LCD_DisplayStringAt(300, 242, (uint8_t *)&text, LEFT_MODE);
                
            if(bluetooth1.readable()) 
            {
                ch=bluetooth1.getc();
                decrem(lc5,nlc5);
               }     
                    
           increm(nlc5);
           
            
            
            if ( (x>= 244 && x<= 472) && (y>= 220 && y<= 265) )  //Fin de commande
               {
                    x=0;
                    y=0;
                    c[4]= 2 ;
                    x=475;
                    y=5;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
                }
        }
            
        if ( c[4] == 2 )
        {
                debut = 0;
                sprintf((char*)text, "COMMANDE TRAITEE");
                BSP_LCD_DisplayStringAt(0,260, (uint8_t *)&text, CENTER_MODE);
        }
        break;
    
      case 5:
        aff(lc6,nlc6);          
        if ( c[5] == 0 )
        {
              if (debut == 0)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "CHOISIR LA COMMANDE");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
              if (debut == 1)
              {
                BSP_LCD_DrawRect(8, 220, 228, 45);
                sprintf((char*)text, "AUTRE COMMANDE EN COURS");
                BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
              }
                
              if ( (debut==0) && (x>= 8 && x<= 236) && (y>= 220 && y<= 265) )
              {
                    x=0;
                    y=0;
                    c[5]= 1 ;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
              }
        }
            
        if ( c[5] == 1 )
        {
            debut=1;
            sprintf((char*)text, "COMMANDE EN COURS");
            BSP_LCD_DisplayStringAt(52, 242, (uint8_t *)&text, LEFT_MODE);
            BSP_LCD_DrawRect(244, 220, 228, 45);
            sprintf((char*)text, "FIN DE COMMANDE");
            BSP_LCD_DisplayStringAt(300, 242, (uint8_t *)&text, LEFT_MODE);
                
            if(bluetooth1.readable()) 
            {
                ch=bluetooth1.getc();
                decrem(lc6,nlc6);
               }     
                    
           increm(nlc6);
           
            
            
            if ( (x>= 244 && x<= 472) && (y>= 220 && y<= 265) )  //Fin de commande
               {
                    x=0;
                    y=0;
                    c[5]= 2 ;
                    x=475;
                    y=5;
                    HAL_Delay(200);
                    BSP_LCD_Clear(LCD_COLOR_WHITE);
                }
        }
            
        if ( c[5] == 2 )
        {
                debut = 0;
                sprintf((char*)text, "COMMANDE TRAITEE");
                BSP_LCD_DisplayStringAt(0,260, (uint8_t *)&text, CENTER_MODE);
        }
        break;
    
    case 6 :
        break;
        
    default:
        break;
}   
    } 
                    
   
}

    //////////////////////////////////////
    ////////////PAGE COMMANDE/////////////
    //////////////////////////////////////
    void page_commande (int *roro,int *bede,int *thethe,int *popo){
    page = 0;
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    drawImage_LogoParisSaclay(0,0);
    sprintf((char*)text, "Page commandes");
    BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, CENTER_MODE);
    
    BSP_LCD_DrawHLine(0,22,480);
    
    drawImage_fleche(447,0);
    
    // LES COMMANDES
   
                                         // Au dessus 22px de la barre + 7//
   /* 8px */ BSP_LCD_DrawRect(8, 29, 228, 74);    /* 8px */    BSP_LCD_DrawRect(244, 29, 228, 74);  /* 8px */
                                                  /* 7px */
   /* 8px */ BSP_LCD_DrawRect(8, 110, 228, 74);   /* 8px */    BSP_LCD_DrawRect(244, 110, 228, 74); /* 8px */
                                                  /* 7px */
   /* 8px */ BSP_LCD_DrawRect(8, 191, 228, 73);   /* 8px */    BSP_LCD_DrawRect(244, 191, 228, 73); /* 8px */
                                              // Au dessous 7px//
    
    //SEGMENTATION DES CASES COMMANDES
    BSP_LCD_DrawHLine(8,79,228);     BSP_LCD_DrawHLine(244,79,228);
    BSP_LCD_DrawHLine(8,159,228);    BSP_LCD_DrawHLine(244,159,228);
    BSP_LCD_DrawHLine(8,239,228);    BSP_LCD_DrawHLine(244,239,228);
     sprintf((char*)text, "Commande #0001");
    BSP_LCD_DisplayStringAt(20,87, (uint8_t *)&text, LEFT_MODE);
     sprintf((char*)text, "Commande #0002");
    BSP_LCD_DisplayStringAt(257, 87, (uint8_t *)&text, LEFT_MODE);
     sprintf((char*)text, "Commande #0003");
    BSP_LCD_DisplayStringAt(20, 167, (uint8_t *)&text, LEFT_MODE);
     sprintf((char*)text, "Commande #0004");
    BSP_LCD_DisplayStringAt(257, 167, (uint8_t *)&text, LEFT_MODE);
     sprintf((char*)text, "Commande #0005");
    BSP_LCD_DisplayStringAt(20, 247, (uint8_t *)&text, LEFT_MODE);
     sprintf((char*)text, "Commande #0006");
    BSP_LCD_DisplayStringAt(257, 247, (uint8_t *)&text, LEFT_MODE);
    
    // CONTENU COMMANDE
    //1
    COMMANDE(&lc1[0], &lc1[1], &lc1[2], &lc1[3], &lc1[4], &lc1[5], &nlc1[0], &nlc1[1], &nlc1[2], &nlc1[3], &nlc1[4], &nlc1[5], &roman, &BD, &theatre, &poesie); 
    sprintf((char*)text, "%d THEATRE(S)",*thethe);
    BSP_LCD_DisplayStringAt(20, 40, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d POESIE(S)",*popo);
    BSP_LCD_DisplayStringAt(20, 60, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d ROMAN(S)",*roro);
    BSP_LCD_DisplayStringAt(140, 40, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d BD", *bede);
    BSP_LCD_DisplayStringAt(140, 60, (uint8_t *)&text, LEFT_MODE);
    //2
    COMMANDE(&lc2[0], &lc2[1], &lc2[2], &lc2[3], &lc2[4], &lc2[5], &nlc2[0], &nlc2[1], &nlc2[2], &nlc2[3], &nlc2[4], &nlc2[5], &roman, &BD, &theatre, &poesie); 
    sprintf((char*)text, "%d THEATRE(S)",*thethe);
    BSP_LCD_DisplayStringAt(257, 40, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d POESIE(S)",*popo);
    BSP_LCD_DisplayStringAt(257, 60, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d ROMAN(S)",*roro);
    BSP_LCD_DisplayStringAt(377, 40, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d BD", *bede);
    BSP_LCD_DisplayStringAt(377, 60, (uint8_t *)&text, LEFT_MODE);
    //3
    COMMANDE(&lc3[0], &lc3[1], &lc3[2], &lc3[3], &lc3[4], &lc3[5], &nlc3[0], &nlc3[1], &nlc3[2], &nlc3[3], &nlc3[4], &nlc3[5], &roman, &BD, &theatre, &poesie); 
    sprintf((char*)text, "%d THEATRE(S)",*thethe);
    BSP_LCD_DisplayStringAt(20, 120, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d POESIE(S)",*popo);
    BSP_LCD_DisplayStringAt(20, 140, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d ROMAN(S)",*roro);
    BSP_LCD_DisplayStringAt(140, 120, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d BD", *bede);
    BSP_LCD_DisplayStringAt(140, 140, (uint8_t *)&text, LEFT_MODE);
    //4
    COMMANDE(&lc4[0], &lc4[1], &lc4[2], &lc4[3], &lc4[4], &lc4[5], &nlc4[0], &nlc4[1], &nlc4[2], &nlc4[3], &nlc4[4], &nlc4[5], &roman, &BD, &theatre, &poesie); 
    sprintf((char*)text, "%d THEATRE(S)",*thethe);
    BSP_LCD_DisplayStringAt(257, 120, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d POESIE(S)",*popo);
    BSP_LCD_DisplayStringAt(257, 140, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d ROMAN(S)",*roro);
    BSP_LCD_DisplayStringAt(377, 120, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d BD", *bede);
    BSP_LCD_DisplayStringAt(377, 140, (uint8_t *)&text, LEFT_MODE);
    //5
    COMMANDE(&lc5[0], &lc5[1], &lc5[2], &lc5[3], &lc5[4], &lc5[5], &nlc5[0], &nlc5[1], &nlc5[2], &nlc5[3], &nlc5[4], &nlc5[5], &roman, &BD, &theatre, &poesie); 
    sprintf((char*)text, "%d THEATRE(S)",*thethe);
    BSP_LCD_DisplayStringAt(20, 200, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d POESIE(S)",*popo);
    BSP_LCD_DisplayStringAt(20, 220, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d ROMAN(S)",*roro);
    BSP_LCD_DisplayStringAt(140, 200, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d BD", *bede);
    BSP_LCD_DisplayStringAt(140, 220, (uint8_t *)&text, LEFT_MODE);
    //6
    COMMANDE(&lc6[0], &lc6[1], &lc6[2], &lc6[3], &lc6[4], &lc6[5], &nlc6[0], &nlc6[1], &nlc6[2], &nlc6[3], &nlc6[4], &nlc6[5], &roman, &BD, &theatre, &poesie); 
    sprintf((char*)text, "%d THEATRE(S)",*thethe);
    BSP_LCD_DisplayStringAt(257, 200, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d POESIE(S)",*popo);
    BSP_LCD_DisplayStringAt(257, 220, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d ROMAN(S)",*roro);
    BSP_LCD_DisplayStringAt(377, 200, (uint8_t *)&text, LEFT_MODE);
    sprintf((char*)text, "%d BD", *bede);
    BSP_LCD_DisplayStringAt(377, 220, (uint8_t *)&text, LEFT_MODE);
   
    
    }
    ///////////////////////////////////////////////////////////////////////////
    
    
    ////////////////////////////////////
    //////////PAGE LISTE////////////////
    ////////////////////////////////////
    void page_liste(){
    page = 1;
    
    drawImage_LogoParisSaclay(0,0);
    drawImage_fleche(447,0);
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    BSP_LCD_DrawHLine(0,22,480);
    
    sprintf((char*)text, "Page liste");
    BSP_LCD_DisplayStringAt(0, LINE(0), (uint8_t *)&text, CENTER_MODE);
    }
    ///////////////////////////////////////////////////////////////////////////
    
    
    ////////////////////////////////////
    ///////////PAGE ACCUEIL/////////////
    ////////////////////////////////////
    void page_accueil(){
    page = 2;
    BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
    
    drawImage_LogoParisSaclay(0,0);
    drawImage_BT(268,60);
    drawImage_market(95,85);
    
    sprintf((char*)text, "Page d'accueil");
    BSP_LCD_DisplayStringAt(0, LINE(2), (uint8_t *)&text, CENTER_MODE);
    
    BSP_LCD_DrawRect(65, 55, 150, 175);   //Bouton commande
    BSP_LCD_DrawHLine(65,210,150);
    sprintf((char*)text, "PAGE COMMANDE");
    BSP_LCD_DisplayStringAt(95, LINE(18), (uint8_t *)&text, LEFT_MODE);
    
    
    BSP_LCD_DrawRect(265, 55, 150, 175);   //Bouton BT
    BSP_LCD_DrawHLine(265,210,150);
    BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
    sprintf((char*)text, "BLUETOOTH");
    BSP_LCD_DisplayStringAt(102, LINE(18), (uint8_t *)&text, CENTER_MODE);
    }
    ///////////////////////////////////////////////////////////////////////////
   
    
    // 0 = Hernani; 1 = Balzac; 2 = Cyrano; 3 = Blacksad; 4 = Boule&Bill; 5 = Cahier; 6 = Cid; 7 = Domjuan; 8 = Fleurs; 9 = gazette; 10 = NULL;
    //ROMAN   = BALZAC 
    //BD      = BLACKSAD, BOULE, GAZETTE
    //THEATRE = HERNANI, CYRANO, CID, DOMJUAN
    //POESIE  = CAHIER, FLEURS
    
    //int l1c1 = 3;  int l2c1 = 7;  int l3c1 = 1;  int l4c1 = 8;  int l5c1 = 2;  int l6c1 = 0;    
    //int nl1c1 = 5; int nl2c1 = 8; int nl3c1 = 8; int nl4c1 = 1; int nl5c1 = 2; int nl6c1 = 4;
    //COMMANDE(&l1c1, &l2c1, &l3c1, &l4c1, &l5c1, &l6c1, &nl1c1, &nl2c1, &nl3c1, &nl4c1, &nl5c1, &nl6c1, &roman, &BD, &theatre, &poesie); 
    //ROMAN = 8 ; BD = 5; THEATRE = 14 ; POESIE = 1 ;
    
    
    // COMPTE LE NOMBRE DE CHAQUE TYPE DE LIVRE
    void COMMANDE(int *L1, int *L2, int *L3, int *L4, int *L5, int *L6, int *n1, int *n2, int *n3, int *n4, int *n5, int *n6, int *rom, int *bede, int *thethe, int*poepoe){
        *rom=0;
        *bede=0;
        *thethe=0;
        *poepoe=0;
             if (*L1==1){*rom=*rom+*n1;}
        else if (*L1==3||*L1==4||*L1==9){*bede = *bede+*n1;}
        else if (*L1==0||*L1==2||*L1==6||*L1==7){*thethe = *thethe+*n1;}
        else if (*L1==5||*L1==8){*poepoe = *poepoe+*n1;}
        
             if (*L2==1){*rom=*rom+*n2;}
        else if (*L2==3||*L2==4||*L2==9){*bede = *bede+*n2;}
        else if (*L2==0||*L2==2||*L2==6||*L2==7){*thethe = *thethe+*n2;}
        else if (*L2==5||*L2==8){*poepoe = *poepoe+*n2;}
        
             if (*L3==1){*rom=*rom+*n3;}
        else if (*L3==3||*L3==4||*L3==9){*bede = *bede+*n3;}
        else if (*L3==0||*L3==2||*L3==6||*L3==7){*thethe = *thethe+*n3;}
        else if (*L3==5||*L3==8){*poepoe = *poepoe+*n3;}
        
             if (*L4==1){*rom=*rom+*n4;}
        else if (*L4==3||*L4==4||*L4==9){*bede = *bede+*n4;}
        else if (*L4==0||*L4==2||*L4==6||*L4==7){*thethe = *thethe+*n4;}
        else if (*L4==5||*L4==8){*poepoe = *poepoe+*n4;}
        
             if (*L5==1){*rom=*rom+*n5;}
        else if (*L5==3||*L5==4||*L5==9){*bede = *bede+*n5;}
        else if (*L5==0||*L5==2||*L5==6||*L5==7){*thethe = *thethe+*n5;}
        else if (*L5==5||*L5==8){*poepoe = *poepoe+*n5;}
        
             if (*L6==1){*rom=*rom+*n6;}
        else if (*L6==3||*L6==4||*L6==9){*bede = *bede+*n6;}
        else if (*L6==0||*L6==2||*L6==6||*L6==7){*thethe = *thethe+*n6;}
        else if (*L6==5||*L6==8){*poepoe = *poepoe+*n6;}
        
        
        return;
        }
        
    void activ_bluetooth (){
                BSP_LCD_Clear(LCD_COLOR_WHITE);
                page_accueil();
                BSP_LCD_SetTextColor(LCD_COLOR_BLUE);
                sprintf((char*)text, "BT EN COURS DE CONNEXION");
                BSP_LCD_DisplayStringAt(270, 250, (uint8_t *)&text, LEFT_MODE);
                
                bluetooth1.printf("AT+NAME=RMAAD\r\n");
                HAL_Delay (1500);
            
                bluetooth1.printf("AT+NAME=TITOF\r\n");
                HAL_Delay (1500);
                
                bluetooth1.printf("AT+ROLE=1\r\n");
                HAL_Delay (1500);
                
                
                bluetooth1.printf("AT+RESET\r\n");
                HAL_Delay (1500);
                
                bluetooth1.printf("AT+CMODE=0\r\n");
                HAL_Delay (1500);
                
                bluetooth1.printf("AT+INQM=0,10,15\r\n");
                HAL_Delay (1500);
                
                bluetooth1.printf("AT+INIT\r\n");
                HAL_Delay (1500);
                
                bluetooth1.printf("AT+INQ\r\n");  // RECHERCHE DES DEVICES
                HAL_Delay (1500);
                
                bluetooth1.printf("AT+BIND=1C,97,1A4CF1\r\n");
                HAL_Delay (1500);
                
                bluetooth1.printf("AT+CMODE=1\r\n");
                HAL_Delay (1500);
                
                bluetooth1.printf("AT+LINK=1C,97,1A4CF1\r\n");
                HAL_Delay (1500);
                BSP_LCD_Clear(LCD_COLOR_WHITE);
                page_accueil();
            }
            
            
            
  void aff(int *lc, int *nl){  
    for (int i=0;i<6;i++){
            if (*(lc+i) ==0)
            {
                drawImage_hernani( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "HERNANI");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==1)
            {
                drawImage_balzac( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "BALZAC");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==2)
            {
                drawImage_cyrano( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "CYRACNO");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==3)
            {
                drawImage_blacksad( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "BLACKSAD");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==4)
            {
                drawImage_boule( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "BOULE&BILL");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==5)
            {
                drawImage_cahier( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "CAHIER");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==6)
            {
                drawImage_cid( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "CID");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==7)
            {
                drawImage_domjuan( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "DOMJUAN");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==8)
            {
                drawImage_fleurs( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "FLEURS");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==9)
            {
                drawImage_gazette( 10+(160*(i/2)),30+(90*(i%2)) );
                sprintf((char*)text, "%d",*(nl+i));
                BSP_LCD_DisplayStringAt(80+(160*(i/2)), 35+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                sprintf((char*)text, "GAZETTE");
                BSP_LCD_DisplayStringAt( 8+(160*(i/2)), 105+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                }
            if (*(lc+i)==10)
            {
                
                }
        }
    }

        
                    
    void decrem(int *lc ,int *nlc)
    { 
            for (int i=0;i<6;i++)
            {
            sprintf((char*)n, "%d", *(lc+i));
                if (ch==*n){
                    *(nlc+i)=*(nlc+i)-1; 
                    }
                if(*(nlc+i)<0){
                     sprintf((char*)text, "SCAN EN TROP");
                     BSP_LCD_DisplayStringAt( 65+(160*(i/2)), 48+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                     BSP_LCD_DrawRect(65+(160*(i/2)), 60+(100*(i%2)), 75, 42);
                     sprintf((char*)text, "Remis en");
                     BSP_LCD_DisplayStringAt(70+(160*(i/2)), 65+(100*(i%2)), (uint8_t *)&text, LEFT_MODE);
                     sprintf((char*)text, "rayon");
                     BSP_LCD_DisplayStringAt(75+(160*(i/2)), 77+(100*(i%2)), (uint8_t *)&text, LEFT_MODE); 
                }
            }
    }
    
    
    void increm(int *nlc)
    {
        for (int i=0;i<6;i++)
        {
            if(page == 1 && x>=(65+(160*(i/2))) && x<=(140+(160*(i/2))) && y>=(60+(100*(i%2))) && y<=(105+(100*(i%2))) && *(nlc+i)<0)
            {
                     *(nlc+i) = *(nlc+i) + 1 ;
                     x=0;y=0;
                     HAL_Delay(200);
                     if(*(nlc+i)==0)
                     {
                         BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
                         BSP_LCD_FillRect((65+(160*(i/2))), (60+(100*(i%2))), 75, 45);
                         BSP_LCD_SetTextColor(LCD_COLOR_BLACK);
                    }
            }   
        }  
    }
    
    void Rx_interrupt() {
            
           /* char texte[]="{*2*:0,*1*:0,*2*:0";
            //int lc1[6] = {10,10,10,10,10,10}; int nlc1[6] = {0,0,0,0,0,0};
            char nombre[20]; 
            bool flag1 = false;
            int start_index = 0, end_index = 0;
        
            //chaine[t]=ESP.getc();
            for (int i=0; i<sizeof(texte); i++)
            {
                if(texte[i] == '*'){
                  flag1 = true;
                  start_index = i+1;
                  break;
                }
            }
        
            for(int i=start_index; i<sizeof(texte); i++){
                if(texte[i] == '*' && flag1 == true){
                    end_index = i;
                }
            }
                    
            for(int i=start_index; i<end_index; i++){
                nombre[i-start_index] = texte[i];
            }
            
            lc1[1]=atoi(nombre);*/

    }