#include "Speaker.h"

Speaker::Speaker(PwmOut* argPin)
{
    this->pin = argPin;
    this->pulseWidth = 0.5;
}

void Speaker::play(Notes note)
{
    switch(note) {
        case DO_4 :
            pin->period_us(1911);
            break;
        case DO_d_4 :
            pin->period_us(1804);
            break;
        case RE_4 :
            pin->period_us(1703);
            break;
        case RE_d_4 :
            pin->period_us(1607);
            break;
        case MI_4 :
            pin->period_us(1517);
            break;
        case FA_4 :
            pin->period_us(1432);
            break;
        case FA_d_4 :
            pin->period_us(1351);
            break;
        case SOL_4 :
            pin->period_us(1276);
            break;
        case SOL_d_4 :
            pin->period_us(1204);
            break;
        case LA_4 :
            pin->period_us(1136);
            break;
        case LA_d_4 :
            pin->period_us(1073);
            break;
        case SI_4 :
            pin->period_us(1012);
            break;
        case DO_5 :
            pin->period_us(956);
            break;
        case DO_d_5 :
            pin->period_us(902);
            break;
        case RE_5 :
            pin->period_us(851);
            break;
        case RE_d_5 :
            pin->period_us(804);
            break;
        case MI_5 :
            pin->period_us(758);
            break;
        case FA_5 :
            pin->period_us(716);
            break;
        case FA_d_5 :
            pin->period_us(676);
            break;
        case SOL_5 :
            pin->period_us(638);
            break;
        case SOL_d_5 :
            pin->period_us(602);
            break;
        case LA_5 :
            pin->period_us(568);
            break;
        case LA_d_5 :
            pin->period_us(536);
            break;
        case SI_5 :
            pin->period_us(506);
            break;
        case DO_6 :
            pin->period_us(478);
            break;
        case DO_d_6 :
            pin->period_us(451);
            break;
        case RE_6 :
            pin->period_us(426);
            break;
        case RE_d_6 :
            pin->period_us(402);
            break;
        case MI_6 :
            pin->period_us(379);
            break;
        case FA_6 :
            pin->period_us(358);
            break;
        case FA_d_6 :
            pin->period_us(338);
            break;
        case SOL_6 :
            pin->period_us(318);
            break;
        case SOL_d_6 :
            pin->period_us(301);
            break;
        case LA_6 :
            pin->period_us(284);
            break;
        case LA_d_6 :
            pin->period_us(268);
            break;
        case SI_6 :
            pin->period_us(253);
            break;
        case SILENCE :
        default :
            this->mute();
            break;
    }
    pin->write(this->pulseWidth);
}

bool Speaker::setPulseWidth(float argPulseWidth)
{
    if ((argPulseWidth >= 0.0) && (argPulseWidth <= 1.0)) {
        this->pulseWidth = argPulseWidth;
        return true;
    }
    else
        return false;    
}

void Speaker::mute()
{

}