#include "MelodyGenerator.h"

MelodyGenerator::MelodyGenerator()
{
    //J.S Bach cello suite 1 prelude first 7 bars
    this->melody = "1,5,u3,u2;u3,5,u3,5;1,5,u3,u2;u3,5,u3,5|1,6,u4,u3;u4,6,u4,6;1,6,u4,u3;u4,6,u4,6|1,7,u4,u3;u4,7,u4,7;1,7,u4,u3;u4,7,u4,7|1,u1,u3,u2;u3,u1,u3,u1;1,u1,u3,u2;u3,u1,u3,u1|1,6,u3,u2;u3,u1,7,u1;6,u1,7,u1;3,5,#4,3|#4,u1,u2,u1;u2,u1,u2,u1;5,u1,u2,u1;u2,u1,u2,u1|7,u2,u5,#u4;u5,u2,u1,u2;7,u2,u1,u2;5,7,6,5|";
    this->cursor = 0;
}

MelodyGenerator::MelodyGenerator(string myMelody)
{
    this->melody = myMelody;
}

vector<Notes>* MelodyGenerator::getMeasure(Scale& mode)
{
    int length = melody.length();
    vector<Notes>* result = new vector<Notes>();
    char currentChar = melody[cursor];

    while(currentChar != '|') {

        bool octaveUp = false;
        bool octaveDown = false;
        bool flat = false;
        bool sharp = false;

        if (currentChar == 'u')
            octaveUp = true;
        else if (currentChar == 'd')
            octaveDown = true;
        else if (currentChar == 'b')
            flat = true;
        else if (currentChar == '#')
            sharp = true;
        else if ((currentChar == ',')||(currentChar == ';')) {
            octaveUp = false;
            octaveDown = false;
            flat = false;
            sharp = false;
        } else {
            Notes currentNote;
            switch(currentChar) {
                case '1' :
                    currentNote = mode.getTonic();
                    break;
                case '2' :
                    currentNote = mode.getSupertonic();
                    break;
                case '3' :
                    currentNote = mode.getMediant();
                    break;
                case '4' :
                    currentNote = mode.getSubdominant();
                    break;
                case '5' :
                    currentNote = mode.getDominant();
                    break;
                case '6' :
                    currentNote = mode.getSuperdominant();
                    break;
                case '7' :
                    currentNote = mode.getSubtonic();
                    break;
            }

            if (sharp)
                currentNote = mode.applySharp(currentNote);
            else if (flat)
                currentNote = mode.applyFlat(currentNote);
            if (octaveUp)
                currentNote = mode.applyOctaveUp(currentNote);
            else if (octaveDown)
                currentNote = mode.applyOctaveDown(currentNote);

            result->push_back(currentNote);
        }

        cursor++;
        if (cursor == length)
            cursor = 0;

        currentChar = melody[cursor];
    }
    
    
        cursor++;
        if (cursor == length)
            cursor = 0;

    return result;
}

void MelodyGenerator::changeMelody(string myMelody)
{
    this->melody = myMelody;
}
