#include "Application.h"

Application::Application(InterruptIn* earSensorPin, AnalogIn* GSRPin, PwmOut* speakerPin) : earbud(earSensorPin), speaker(speakerPin), GSRSens(GSRPin)
{
    thresholdHR = 0.0;
    thresholdGSR = 0.0;
}

void Application::Init()
{
    printf("Initialization.. waiting 14s");
    fflush(stdout);
    wait(4); // Time for GSR measure to stabilize
    
    /*
    * Get #NBGSR measure of GSR and Heartrate  each 0.5 s 
    * in order to establish nominal threshold
    */
    float sumGSR, sumHR = 0.0;
    for(int i = 0 ; i<NBGSRVALUE ; i++) {
        sumGSR += GSRSens.getGSRValue();
        sumHR += earbud.getHeartRate();
        wait(0.5);

    }
    thresholdGSR = sumGSR/NBGSRVALUE;
    thresholdHR = sumHR/NBGSRVALUE;

}

void Application::Run()
{
    MelodyGenerator melodyGen;
    MajorScale scale1(SOL_4);
    GypsyScale scale2(MI_4);
    float heartRate, measureGSR;

    while(true) {

        heartRate = earbud.getHeartRate();
        measureGSR = GSRSens.getGSRValue();
        printf("\r\nHeartrate : %0.0f (nominal : %0.3f) \r\nGSR       : %0.4f (nominal : %0.4f) \r\n", heartRate, thresholdHR, measureGSR, thresholdGSR); // for debug purpose

        if(heartRate <30) {
            speaker.play(SILENCE);
            heartRate = earbud.getHeartRate();
            wait(1);
        } else {
            if (measureGSR < thresholdGSR) {
                melo = melodyGen.getMeasure(scale1);
                printf("\tMajor scale\r\n");
            } else {
                melo = melodyGen.getMeasure(scale2);
                printf("\tGypsy scale\r\n");
            }
            
            timerNote.attach(this, &Application::playMeasure, 0.3 - ((heartRate - thresholdHR) * 0.0015));
        }
    }
}

void Application::playMeasure()
{
    static int it = 0;
    if(it < melo->size()) {
        speaker.play((*melo)[it]);
        ++it;
    }
    else {
        it = 0;
        timerNote.detach();
    }
}