#include "mbed.h"
 
/*
Outlines the function of the Library’s I2C message interface, and contains the complete message reference to control and operate the MGC3X30 system.
 
  Example:
  @code
*/

#include "mbed.h"
#include "MGC3130.h"

SensorData * msg = NULL;
MGC3130 device (PB_7,PA_15, PB_1, false);
Serial pc(SERIAL_TX, SERIAL_RX);
void init()
{
    pc.printf("\r\n  init\r\n ");
    AirWheelDetection air(true);
    device.setRuntimeParameter(&air);

    TouchDetection touch(true);
    device.setRuntimeParameter(&touch);

    OutputEnable setting;
    setting.enableGestureData(true)->enableTouchInfo(true)->enableAirWheelInfo(true)->enableNoisePower(false)
    ->enablexyzPosition(false)->enableDSPStatus(false)->enableUncalibratedSignal(false)->enableSignalDeviation(false);
    device.setRuntimeParameter(&setting);
}

void touch()
{
    pc.printf("\r\n  touch \r\n ");
    TouchInfo * info = msg->getTouchInfo();

    if (info == NULL)
        return;

    if (info->isTapCenterElectrode() == false)
        return;
}

void airWheel()
{
    pc.printf("\r\n  airWheel \r\n ");
    int * wheel = msg->getAirWheelInfo();
    if (wheel == NULL)
        return;
}

void gesture()
{
    pc.printf("\r\n  gesture \r\n ");
    GestureInfo * info = msg->getGestureInfo();

    if (info == NULL)
        return;

    switch (info->getRecognizedGesture()) {
            //Garbage Model
        case 1 :
            break;
            pc.printf("\r\n  Flick West To East \r\n ");
            //Flick West To East
        case 2 :
        pc.printf("\r\n  Flick West To East \r\n ");
            break;
            //Flick East To West
        case 3 :
        pc.printf("\r\n  Flick South To North \r\n ");
            break;
            //Flick South To North
        case 4 :
        pc.printf("\r\n  //Flick North To South \r\n ");
            break;
            //Flick North To South
        case 5 :
        pc.printf("\r\n  //Flick North To South \r\n ");
            break;
    }
}

int main()
{
    init();

    while(1) {
        msg = device.readSensorData();

        if (msg == NULL)
            continue;

        touch();

        gesture();

        airWheel();
    }
}
 

// I2C i2c(PB_7,PA_15);
 
// DigitalOut myled(LED1);
 
// Serial pc(SERIAL_TX, SERIAL_RX);
 
 
// int main()
// {
 
//     char data_write[2];
//     char data_read[2];

//     while (1) {
//         //Read accelerometer register
//         data_write[0] = AG_WHO_AM_I;
//         i2c.write(0xd4, data_write, 1, 0 ); // no stop
//         i2c.read(0x6a, data_read, 2, 0);
 
//         // Display result
//         pc.printf("data_read[0] = %x\n", data_read[0]);
//         pc.printf("data_read[1] = %x\n", data_read[1]);
//         myled = !myled;
//         wait(1);



//     }
 
// }
 
