#include "mbed.h"
#include "MPU6050.h"
#include "stm32746g_discovery_lcd.h"         // include les bibliothèques
#include "stm32746g_discovery_ts.h"  
#include <math.h>


TS_StateTypeDef TS_State;           //touchscreen
uint8_t status;
int TouchScreen=1;
Serial pc(USBTX, USBRX);
I2C    i2c(I2C_SDA, I2C_SCL);       //Déclaration de SDA et SCL ainsi que I2C
MPU6050 mpu(i2c);

                        
PwmOut servo1 (D9);                 //Déclaration des pins des servo-moteurs
PwmOut servo2 (D10);

int16_t ax, ay, az;
int16_t gx, gy, gz;
int moyx, moyy, moyz ;              //Déclaration des variables

Timer timer;


Ticker flipper;

double t1, t2;
 
 

void servo_ctrl()
{
        if (t2 <0) {
            servo1.pulsewidth_us(2000);

        }
        else if (t2 > 0) {
            servo1.pulsewidth_us(1200);

        }                                   //fonctionnalité des servo-moteurs
        if (t1 <0) {
            servo2.pulsewidth_us(2000);

        }
       else if (t1 > 0) {
           servo2.pulsewidth_us(1200);

        }
}
    

int main()
{

    BSP_LCD_Init();
    BSP_LCD_LayerDefaultInit(LTDC_ACTIVE_LAYER, LCD_FB_START_ADDRESS);
    BSP_LCD_SelectLayer(LTDC_ACTIVE_LAYER);
    
    BSP_LCD_SetBackColor(LCD_COLOR_BLACK);
    BSP_LCD_SetTextColor(LCD_COLOR_WHITE);
    BSP_LCD_DisplayStringAt(0,LINE(5), (uint8_t *)"Start commencement?", CENTER_MODE);
    status =  BSP_TS_Init(BSP_LCD_GetXSize() , BSP_LCD_GetYSize());                     //déclaration ecran pour le touchscreen
    
     while(TouchScreen) {
        
        BSP_TS_GetState(&TS_State);
        if (TS_State.touchDetected){                                                //rien ne se passe tant qu'il n'y a aucun appui sur l'ecran
            TouchScreen =0;
            }
        }



    BSP_LCD_Clear(LCD_COLOR_BLACK);
    BSP_LCD_SetFont(&LCD_DEFAULT_FONT);
    BSP_LCD_SetBackColor(LCD_COLOR_WHITE);
    BSP_LCD_SetTextColor(LCD_COLOR_RED);

    int32_t xPos=240,yPos=150;                          // déclaration position initiale de la bille


    char buffer[10] = {0};
    char tab [10] = {0};

    pc.printf("MPU6050 test\r\n");
    pc.printf("MPU6050 initialize \r\n");

    mpu.initialize();                                   //Initialisation du MPU-6050



    pc.printf("MPU6050 testConnection\r\n");

    bool mpu6050TestResult = mpu.testConnection();
    if(mpu6050TestResult) {
        pc.printf("MPU6050 test passed \r\n");
    } else {
        pc.printf("MPU6050 test failed \r\n");
    }

    
    servo1.period_ms(20);                       // déclaration de la période des servo-moteurs
    servo2.period_ms(20);
    flipper.attach(&servo_ctrl, 1.0);           // nous demandons toute les secondes si il y a une action
    

    while (1){

        BSP_LCD_Clear(LCD_COLOR_BLACK);
        BSP_LCD_FillCircle(xPos,yPos,4);

        sprintf(buffer, "%d", xPos);
        sprintf(tab, "%d", yPos);
        BSP_LCD_DisplayStringAt(0,0,(uint8_t*)buffer, LEFT_MODE);
        BSP_LCD_DisplayStringAt(60,0,(uint8_t*)tab, LEFT_MODE);


       mpu.getMotion6(&ax, &ay, &az, &gx, &gy, &gz);            // récupération des valeurs bruts du MPU-6050
       t1=atan2(-(double)ay,-(double)ax)*(180/3.1415);          // calcul en degrès des valeurs bruts 
       t2=atan2(-(double)az,-(double)ax)*(180/3.1415);
       pc.printf("%6d %6d %6d %6.2f %6.2f\r\n",ax,ay,az,t1,t2); //affichage des valeurs bruts et degrès (voir sur putty)

        if (t2 < 0) {
            xPos = xPos - 3;
            
        }
        else if (t2 > 0) {
            xPos = xPos + 3;
            
                                                // Selon l'angle des axes du MPU-6050 la position de la bille change 
        }
        
        if (t1 <0) {
            yPos = yPos + 3;
            
            
        }
        else if (t1 > 0) {
            yPos = yPos - 3;
           

        }
        

        if (xPos<=4) {
            xPos = 4;
        } else if (xPos>=475) {
            xPos = 475;
        }

        if (yPos<=4) {                      // Avec cela la bille ne peut pas sortir de l'écran
            yPos = 4;
        } else if (yPos>=267) {
           yPos = 267;
        }

    }
}
