#include "mbed.h"

Serial device(SERIAL_TX, SERIAL_RX);

DigitalOut out1(D2);
DigitalOut out2(D3);
DigitalOut out3(D4);
DigitalOut out4(D7);
DigitalOut out5(D8);


void Rx_interrupt();
void SetOutput();
void SetTime();

char c = 0;
char time_enable = 0;
int delay_ms = 75;

int main()
{
    device.attach(&Rx_interrupt, Serial::RxIrq);
    while(1) {
        if(time_enable == 1 && c != 255) {
            SetTime();
        } else if(c != 0) {
            SetOutput();
        }
    }
}

void Rx_interrupt()
{
    c = device.getc();
    if (c == 255)
    {
        time_enable = 1;
    }
    //device.putc('x'); // Ter controle
}

void SetOutput()
{
    __disable_irq(); // disables interrupts
    if(c > 47 && c < 54) {
        if(c == 49) {
            out1 = 1;
            out2 = 0;
            out3 = 0;
            out4 = 0;
            out5 = 0;
            //device.putc('1');
        } else if(c == 50) {
            out1 = 0;
            out2 = 1;
            out3 = 0;
            out4 = 0;
            out5 = 0;
            //device.putc('2');
        } else if(c == 51) {
            out1 = 0;
            out2 = 0;
            out3 = 1;
            out4 = 0;
            out5 = 0;
            //device.putc('3');
        } else if(c == 52) {
            out1 = 0;
            out2 = 0;
            out3 = 0;
            out4 = 1;
            out5 = 0;
            //device.putc('4');
        } else if(c == 53) {
            out1 = 0;
            out2 = 0;
            out3 = 0;
            out4 = 0;
            out5 = 1;
            //device.putc('5');
        }
    } else {
        if((c & 1) == 1) { //Selecteert bit0 en kijkt als die 1 is
            out1 = 1;
        } else {
            out1 = 0;
        }
        if((c & 2) == 2) { //Selecteert bit1 en kijkt als die 1 is
            out2 = 1;
        } else {
            out2 = 0;
        }
        if((c & 4) == 4) { //Selecteert bit2 en kijkt als die 1 is
            out3 = 1;
        } else {
            out3 = 0;
        }
        if((c & 8) == 8) { //Selecteert bit3 en kijkt als die 1 is
            out4 = 1;
        } else {
            out4 = 0;
        }
        if((c & 16) == 16) { //Selecteert bit4 en kijkt als die 1 is
            out5 = 1;
        } else {
            out5 = 0;
        }
    }
    c = '0';
    __enable_irq(); //enables interrupts
    device.putc('r'); //sends a byte for confirmation
    wait_ms(delay_ms);

    out1 = 0;
    out2 = 0;
    out3 = 0;
    out4 = 0;
    out5 = 0;
}

void SetTime() {
    delay_ms = (int)c;
    time_enable  = '0';
}