//made case 2 which is has our main
#include "mbed.h"
#include "TFC.h"
#include <cmath>

 
//This macro is to maintain compatibility with Codewarrior version of the sample.   This version uses the MBED libraries for serial port access
Serial PC(USBTX,USBRX);


 
 //This ticker code is used to maintain compability with the Codewarrior version of the sample.   This code uses an MBED Ticker for background timing.
 
#define NUM_TFC_TICKERS 4

Ticker TFC_TickerObj;
 
volatile uint32_t TFC_Ticker[NUM_TFC_TICKERS];
 
void TFC_TickerUpdate()
{
    int i;
 
    for(i=0; i<NUM_TFC_TICKERS; i++)
     {
        if(TFC_Ticker[i]<0xFFFFFFFF) 
        {
            TFC_Ticker[i]++;
        }
    }
}
 
//finds light intensity values of lines.
 
int FindBlack();

// finds and sets by reference the values of the left and right bounds
void Bounds(int &, int &, int);

// finds distance between bounds 
int distance(int &, int &, int);

// returns interger for turn direction 0 for left 1 for right

int turnDir( int &, int &, int, int);
int startstop(int);

void turnLeft(int &, int &, int, int);  //needs to be finished
void turnRight(int &, int &, int, int);  //needs to be finished
 
int main()
{
    uint32_t i,t,time = 0;
    
    int a = 200, b = 200, d = 200;
    
    int data[128];
    
    int black = 0;
  
    PC.baud(9600);
    TFC_TickerObj.attach_us(&TFC_TickerUpdate,2000);
   
    TFC_Init();
    
    bool didInit  = false  ; // flag for track calibration 
    
    for(;;)
    {      
        //TFC_Task must be called in your main loop.  This keeps certain processing happy (I.E. Serial port queue check)
         //   TFC_Task();

            //This Demo program will look at the middle 2 switch to select one of 4 demo modes.
            //Let's look at the middle 2 switches
            switch((TFC_GetDIP_Switch()>>1)&0x03)
            {
            default:
            case 0 ://initilazation case
                if(TFC_Ticker[0]>50 && TFC_LineScanImageReady>0)
                {
                    TFC_Ticker[0] = 0;
                    TFC_LineScanImageReady=0;
                    if(TFC_PUSH_BUTTON_0_PRESSED&& didInit == false)
                    {
                        black = FindBlack();
                        d=distance(a,b,black);
                        
                        PC.printf("%d \n" , a  );
                        PC.printf("%d \n", b );
                        PC.printf("%d \n", black);
                        PC.printf("%d \n" , d );                    
                        
                        didInit = true; // sets initialzation to true
                    }
                }
                TFC_SetServo(0,0.0);
                
                // this is test code to have the car print if a turn case happened.
                
                if(didInit) // check to see if initalized 
                {
                    if(d < distance(a,b,black))
                        {
                            int whichTurn = 2; // impossible for function to return
                            
                            whichTurn = turnDir(a,b,black,d); // sets which turn to 0 for left and 1 for right
                            
                            PC.printf("%d \n", whichTurn);
                        }
                }        
                break;                   
                    
            case 1: // moves servo and prints pot value.
                break;
                
            case 2 ://case 2 will run program after case 0
                TFC_HBRIDGE_ENABLE;
                if(TFC_PUSH_BUTTON_0_PRESSED)
                {
                    while(true)
                    {
                        //dark=FindBlack();//determines if its dark
                        while((d < (distance(a,b,black)*1.02))&&(d > (distance(a,b,black)*.98)))//if straight line it just goes forward
                        {
                            TFC_SetMotorPWM(.6,.6);
                        }
                        if(turnDir(a,b,black,d)==1)//straight line is broken determine direction if 1 go right
                        {
                            turnRight(a,b,black,d);
                        }
                        if(turnDir(a,b,black,d)==0)//straight line is broken determine direction if 0 go right
                        {
                            turnLeft(a,b,black,d);
                        }
                        /*if(FindBlack()>black)//if white line then find black will return starting value because no black line  // change to findblack()>black
                        {
                            TFC_SetMotorPWM(.6,.6);//go straight for given time
                            wait(0.146);
                            continue;// start loop over and see where you are
                        }
                        if(dark>black)//determine if hill then slow down until hill is over
                        {
                            TFC_SetMotorPWM(0,0);
                            wait(0.146);
                            continue;
                        }
                        if(dark<black)//determine if dark then go foreword 
                        {
                            TFC_SetMotorPWM(.6,.6);
                            wait(0.143);
                            continue;
                        }
                        if(startstop()==1)// if start line is seen stop
                        {
                            TFC_SetMotorPWM(0,0);
                            TFC_HBRIDGE_DISABLE;
                            break;
                        }
                        */
                    }       
                }
                break;
            
            case 3 :
                break;
            }
    }
    
 
}


// finds and sets by reference the values of the left and right bounds

void bounds(int &a,int &b,int black)
{
     for(int i=0; i<128; i++)
     {
         if(i==0)
         {
             a = i;
         }
     
        else if(TFC_LineScanImage0[i] <= black)
         {
            //if there are to black values next to eachother it sets a to newer inside value.
            if ( a == 0 && i!=0)
                a = i;
                
            else if( (i-a) == 1 )
            {
                a = i;   
            }    
            
            // if there is a space between black values the next black value is the right bound.
            else
            {
              // sets the right inside bound and ends the loop.
         
              b = i;
              break;   
            }
         }
       } 
}         
int FindBlack()
{
    int low1=2000,low2=2000;
    for(int i=2;i<64;i++)//first half of line scan
    {
        int ave=(TFC_LineScanImage0[i-2]+TFC_LineScanImage0[i-1]+TFC_LineScanImage0[i])/3;
        if(i==2)
        {
            low1=ave;//first loop sets lowest average
        }
        if(low1>ave)
        {
            low1=ave;
        }
    }
    for(int i=66;i<128;i++)//second half of line scan
    {
        int ave2=(TFC_LineScanImage0[i-2]+TFC_LineScanImage0[i-1]+TFC_LineScanImage0[i])/3;
        if(i==66)
        {
            low2=ave2;
        }
        if(low2>ave2)
        {
            low2=ave2;
        }
        if(low1==low2)
        {
            return low1; //confirms bothe lines and breaks loop returns black
        }   
    }
    if(low1>low2)
    {
        return low1;
    }
    else
    {
        return low2;
    }
}
int distance(int &a, int &b, int black)
{
    bounds(a,b,black);
    return (b-a);
}

int turnDir( int &a, int &b, int black, int d)
    {
        int l = 200, r = 200;
        
        bounds(a,b,black); // resets bounds for start of program
        
        while(d != distance(l,r,black)) // keeps checking rate of change while approaching turn
            {
                if( abs(a-l) > abs(b-r) ) // if the change in the left direction is greater than the right
                    {
                        return 0; // this returns left
                    }
                
                if( abs(a-l) < abs(b-r)) // if the change in the right direction is greater than the left
                    {
                        return 1; // this returns right
                    }
                    
             }
    } 
 void turnLeft(int &a, int &b,int black,int d)
    {
        // waits for the amount of time it takes to reach the turn
        wait(.146);
        
         
              //   turns the wheels to the angle they need to be 
              //   while the distance between the lines
              //   indicate the car is in a turn
                
        while(((d < (distance(a, b, black)*1.27))&&(d!=distance(a,b,black)))||(b==128))
        {
            TFC_SetServo(0,-.214652);
        }
            // returns the wheels back to straight
            
         TFC_SetServo(0,0.0);
    }           
void turnRight(int &a, int &b,int black,int d)
        {
            // waits for the amount of time it takes to reach the turn
            wait(.146);
            while(((d < (distance(a, b, black)*1.27))&&(d!=distance(a,b,black)))||(b==128))
            {
                TFC_SetServo(0,.2688640);
            }
            TFC_SetServo(0,0.0);
        }
int startstop(int black)
    {
        int data[128];
        int counter=0;
        
        for(int i=0;i<128;i++)
        {
            if(TFC_LineScanImage0[i]<=black)
            {                 // zero is black                   
                data[i]=0;
                counter++;
            }
            else
            {                    // one is white
                data[i]=1;
            }
        }
        if (counter>6)
        {
            return 1;
        }
        else
        {
            return 0;
        }
    }
            
     