#include "mbed.h"
#include "WIZnetInterface.h"
#include <string>

//#define USE_DHCP    1

#define LOOPBACKPORT    80

const char * IP_Addr    = "192.168.1.239";
const char * IP_Subnet  = "255.255.255.0";
const char * IP_Gateway = "192.168.1.1";
unsigned char MAC_Addr[6] = {0x00,0x08,0xDC,0x12,0x34,0x56};

DigitalOut sw(PA_8);
Serial pc(USBTX, USBRX);

SPI spi(PA_7,PA_6,PA_5);

WIZnetInterface ethernet(&spi,PB_6,PA_3);

//WIZnetInterface ethernet(PA_7, PA_6, PA_5, PB_6, PA_3);


char ans_str[]="HTTP/1.1 200 OK\r\nContent-Type: text/html\r\n\r\n<!DOCTYPE HTML>\r\n<html>\r\nHello from stm32</html>\r\n";

TCPSocketServer server;
TCPSocketConnection client;
bool  serverIsListening = false;

const string        PASSWORD = "secret";    // change as you like
const string        HTTP_OK = "HTTP/1.0 200 OK";
const string        MOVED_PERM = "HTTP/1.0 301 Moved Permanently\r\nLocation: ";
const string        UNAUTHORIZED = "HTTP/1.0 401 Unauthorized";

string              httpHeader;     // HTTP header
string              httpContent;    // HTTP content


void http_send(TCPSocketConnection& client, string& header, string& content) {
    char    content_length[5] = { };

    header += "\r\nContent-Type: text/html\r\n";
    header += "Content-Length: ";
    sprintf(content_length, "%d", content.length());
    header += string(content_length) + "\r\n";
    header += "Pragma: no-cache\r\n";
    header += "Connection: About to close\r\n";
    header += "\r\n";

    string  webpage = header + content;
    client.send (const_cast<char*>(webpage.c_str ()), webpage.length ());
}

////////////////////////
// analyse the url given
// return values: -1 invalid password
//                -2 no command given but password valid
//                -3 just refresh page
//                 0 switch off
//                 1 switch on
//
//                The string passed to this function will look like this:
//                GET /password HTTP/1.....
//                GET /password/ HTTP/1.....
//                GET /password/?sw=1 HTTP/1.....

//                GET /password/?sw=0 HTTP/1.....
int8_t analyse_get_url(string& str) {
    if(str.substr(5, PASSWORD.size()) != PASSWORD)
        return(-1);

    uint8_t pos = 5 + PASSWORD.size();

    if(str.substr(pos, 1) == " ")
        return(-2);

    if(str.substr(pos, 1) != "/")
        return(-1);

    pos++;

    string  cmd(str.substr(pos, 5));

    if(cmd == "?sw=0")
        return(0);

    if(cmd == "?sw=1")
        return(1);

    return(-3);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
string& moved_perm(uint8_t flag) {
    if(flag == 1)
        httpContent = "/" + PASSWORD + "/";
    else
        httpContent = "";

    httpContent += "<h1>301 Moved Permanently</h1>\r\n";

    return(httpContent);
}

/**
 * @brief
 * @note
 * @param
 * @retval
 */
string& view(uint8_t status) {
    httpContent = "<h2>Web Switch</h2>\r\n";
    
    pc.printf("Status =%d\r\n",status);

    if(status == 1) {
        httpContent += "<pre>\r\n  <font color=#FF0000>ON</font>";
        httpContent += " <a href=\"./?sw=0\">[switch off]</a>\r\n";
    }
    else {
        httpContent += "<pre>\r\n  <font color=#00FF00>OFF</font>";
        httpContent += " <a href=\"./?sw=1\">[switch on]</a>\r\n";
    }

    httpContent += "  <a href=\".\">[refresh status]</a>\r\n";
    httpContent += "</pre>\r\n";
    httpContent += "<hr>\r\n";
    return httpContent;
}
///////////////////////////////////

int main() {
    
 //   mbed_mac_address((char *)MAC_Addr); //Use mbed mac addres
    
    //Set serial port baudrate speed: 115200
    pc.baud(115200);
    
    pc.printf("Start\r\n");

  //  char buffer[512];
  
  
  uint8_t sts = 0;
    

    
        int ret = 1; 
        #if USE_DHCP
        
        ret = ethernet.init(MAC_Addr);
        #else
        ret = ethernet.init(MAC_Addr,IP_Addr,IP_Subnet,IP_Gateway);
        #endif
        pc.printf("res init=%d\r\n",ret);
        
        if (!ret) {
            pc.printf("Initialized, MAC: %s\r\n", ethernet.getMACAddress());
            ret = ethernet.connect();
            if (!ret) {
                pc.printf("IP: %s, MASK: %s, GW: %s\r\n",
                          ethernet.getIPAddress(), ethernet.getNetworkMask(), ethernet.getGateway());
            } else {
                pc.printf("Error ethernet.connect() - ret = %d\r\n", ret);
                exit(0);
            }
        } else {
            pc.printf("Error ethernet.init() - ret = %d\r\n", ret);
            exit(0);
        }
        pc.printf("End init \r\n");

        
    //setup tcp socket
        if(server.bind(LOOPBACKPORT) < 0) {
            pc.printf("TCP server bind failed.\n\r");
            return -1;
        }
        else {
            pc.printf("TCP server bind succeeded.\n\r");
            serverIsListening = true;
        }

        if(server.listen(1) < 0) {
            pc.printf("TCP server listen failed.\n\r");
            return -1;
        }
        else {
            pc.printf("TCP server is listening...\n\r");
        }        
        
        
        
        
        
    
   while(serverIsListening) 
   {
        if(server.accept(client) >= 0) 
        {
            char    buf[1024] = { };
            size_t  size = 0;
            
            pc.printf("Client connected!\n\rIP: %s\n\r", client.get_address());
            
            switch(client.receive(buf, 1023)) {
            case 0:
                pc.printf("Recieved buffer is empty.\n\r");
                break;

            case -1:
                pc.printf("Failed to read data from client.\n\r");
                break;

            default:
                size = strlen(buf);

                string  received((char*)buf);

                if(received.substr(0, 3) != "GET") {
                    httpHeader = HTTP_OK;
                    httpContent = "<h1>200 OK</h1>";
                    http_send(client, httpHeader, httpContent);
                    continue;
                }

                if(received.substr(0, 6) == "GET / ") {
                    httpHeader = HTTP_OK;
                    httpContent = "<p>Usage: http://host_or_ip/password</p>\r\n";
                    http_send(client, httpHeader, httpContent);
                    continue;
                }

                int cmd = analyse_get_url(received);

                if(cmd == -2) {

                    // redirect to the right base url
                    httpHeader = MOVED_PERM;
                    http_send(client, httpHeader, moved_perm(1));
                    continue;
                }

                if(cmd == -1) {
                    httpHeader = UNAUTHORIZED;
                    httpContent = "<h1>401 Unauthorized</h1>";
                    http_send(client, httpHeader, httpContent);
                    continue;
                }

                if(cmd == 1) {
                    sw = 1; // switch on
                    sts = 1;
                    pc.printf("switch ON\n\r");
                }

                if(cmd == 0) {
                    sw = 0; // switch off
                    sts = 0;
                    pc.printf("switch OFF\n\r");
                }

                httpHeader = HTTP_OK;
                http_send(client, httpHeader, view(sts));
            }

            client.close();

            pc.printf("Connection closed.\n\rTCP server is listening...\n\r");
        }
       }
    
    
 
}
