/* Copyright C2013 Doug Anson, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files the "Software", to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
 
 // class support
 #include "MBEDUbloxGPS.h"
 
 // CHECK_TALKER Macro
 #define _CHECK_TALKER(s)       ((buf[3] == s[0]) && (buf[4] == s[1]) && (buf[5] == s[2]))
 
 // temporary buffer length
 #define GPS_BUFFER_LENGTH      128
 
 // default constructor
 MBEDUbloxGPS::MBEDUbloxGPS(RawSerial *pc) : Connector::Location(pc) {
     this->m_gps = new GPSI2C();
     if (this->m_gps != NULL) {
        this->m_gps->init();
     }
 }
 
 // default destructor
 MBEDUbloxGPS::~MBEDUbloxGPS() {
     if (this->m_gps != NULL) {
         this->m_gps->powerOff();
         delete this->m_gps;
     }
 }
 
 // update the location
 void MBEDUbloxGPS::updateLocation() {
     char buf[GPS_BUFFER_LENGTH+1];
     memset(buf,0,GPS_BUFFER_LENGTH+1);
     this->m_pc->printf("GPS: in updateLocation()...\r\n");
     if (this->m_gps != NULL) {
         this->m_pc->printf("GPS: Checking for Location...\r\n");
         int ret = this->m_gps->getMessage(buf,GPS_BUFFER_LENGTH);
         if (ret > 0) {
            this->m_pc->printf("GPS: Buffer: %s\r\n",buf);
            int len = LENGTH(ret);
            if ((PROTOCOL(ret) == GPSParser::NMEA) && (len > 6)) {
                this->m_pc->printf("GPS: Protocol is NMEA...\r\n");
                if (_CHECK_TALKER("GLL")) {
                    double la = 0, lo = 0;
                    char ch;
                    if (this->m_gps->getNmeaAngle(1,buf,len,la) && 
                        this->m_gps->getNmeaAngle(3,buf,len,lo) && 
                        this->m_gps->getNmeaItem(6,buf,len,ch) && ch == 'A')
                    {
                        sprintf(this->m_latitude,"%.5f",la);
                        sprintf(this->m_longitude,"%.5f",lo); 
                    }
                } else if (_CHECK_TALKER("GGA") || _CHECK_TALKER("GNS") ) {
                    double a = 0; 
                    if (this->m_gps->getNmeaItem(9,buf,len,a)) // altitude msl [m]
                        sprintf(this->m_msl_altitude_m,"%.1f",a);
                } else if (_CHECK_TALKER("VTG")) {
                    double s = 0; 
                    if (this->m_gps->getNmeaItem(7,buf,len,s)) // speed [km/h]
                        sprintf(this->m_speed,"%.1f",s); 
                }
                
                this->m_pc->printf("GPS: Latitude: %s Longitude: %s Altitude: %s Speed: %s\r\n",
                                   this->m_latitude,this->m_longitude,this->m_msl_altitude_m,this->m_speed);
            }
         }
     }
 }