/**
 * @file    BLEBLEBLELocation.cpp
 * @brief   mbed CoAP Endpoint BLE BLELocation class
 * @author  Doug Anson/Chris Paola
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "BLELocation.h"

// UartRPCFunctions
#include "UartRPCFunctions.h"

#ifdef DBG
    #undef DBG
#endif
#define DBG  std::printf
    
// Constructor
BLELocation::BLELocation(const RawSerial *pc) : Connector::Location(pc) {
}

// Destructor
BLELocation::~BLELocation() {
}

// dispatch our location update request
void BLELocation::dispatchUpdateRequest() {
    //this->m_pc->printf("BLELocation:dispatchUpdateRequest: dispatching location update request...\r\n");
    ble_rpc_get_location(this);
}

// set the default location
void BLELocation::setDefault(float latitude,float longitude,float altitude,float speed) {
    sprintf(this->m_latitude,"%.5f",latitude);
    sprintf(this->m_longitude,"%.5f",longitude);
    sprintf(this->m_msl_altitude_m,"%.1f",altitude);
    sprintf(this->m_speed,"%.1f",speed);
}

// process the location update response
void BLELocation::processLocationUpdateResponse(char *response,int response_length) {
    float latitude = 0.0;
    float longitude = 0.0;
    float altitude = 0.0;
    float speed = 0.0;
    bool present = false;
            
    if (response != NULL && response_length > 0) {
        //DBG("BLELocation:processLocationUpdateResponse: data(%d): %s\r\n",response_length,response);
        for(int i=0;i<response_length;++i) {
            if (response[i] == ':') {
                response[i] = ' ';
                present = true;
            }
        }
        
        // fill with defaults if not presented with new ones...
        if (!present) {
            sprintf(response,"%s %s %s %s",this->m_latitude,this->m_longitude,this->m_msl_altitude_m,this->m_speed);
        }
        
        // parse
        sscanf((char *)response,"%f%f%f%f",&latitude,&longitude,&altitude,&speed);
        this->setDefault(latitude,longitude,altitude,speed);
        
        // check for disabled location 
        if (latitude < 1.0 && longitude < 1.0 && speed < 0.0 && altitude < 0) {
            DBG("BLELocation: Location reporting is DISABLED in UART_PROXY...\r\n");
            ::Connector::Location::initBuffers();
        }
        else if (!present) {
            // using cached values
            DBG("BLELocation (CACHED): latitude=%s longtiude=%s altitude=%s speed=%s\r\n",
                this->m_latitude,this->m_longitude,this->m_msl_altitude_m,this->m_speed);
        }
        else {
            // latest values
            DBG("BLELocation (CURRENT): latitude=%s longtiude=%s altitude=%s speed=%s\r\n",
                this->m_latitude,this->m_longitude,this->m_msl_altitude_m,this->m_speed);
        }
    }
    else {
        // no reponse
        DBG("BLELocation: EMPTY response received! Assuming DISABLED.\r\n");
        ::Connector::Location::initBuffers();
    }
}

// update our location
void BLELocation::updateLocation() {
    // dispatch an update request
    this->dispatchUpdateRequest();
}