/**
 * @file    UartRPC.h
 * @brief   BLE UART RPC header
 * @author  Doug Anson
 * @version 1.0
 * @see     
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 #ifndef __UART_RPC_H__
 #define __UART_RPC_H__
 
 #include "mbed.h"
 #include <stdarg.h>
 #include "BLEDevice.h"
 #include "Dispatcher.h"
 #include "BLELocation.h"
 
 // callback function for dispatch callbacks (
 typedef void (*ble_dispatch_callback_fn)(bool);
  
 class UartRPC {
    public:
        UartRPC(BLEDevice &ble);
        
        // remote dispatch
        int               dispatch(uint8_t fn_id,void *cb,uint8_t *response,int response_length,const char *format,...);
        
        // local accumulate and dispatch of packets
        bool              accumulate(uint8_t *buffer,int buffer_length);
        void              dispatch();
        bool              localDispatchAvailable(void);
        int               retrieveLocalDispatch(uint8_t *buffer,int buffer_length);
        void              setLocationInstance(BLELocation *location);
        
    private:       
        void              resetLocalDispatch(void);
        
        Dispatcher        m_dispatcher;
        SplitterAssembler m_recv_accumulator;
        bool              m_local_dispatch_available;
        char             *m_recv_raw_data;
        int               m_recv_raw_data_length;
        void             *m_cb;
        BLELocation      *m_location;
 };
 
 #endif // __UART_RPC_H__