/* Copyright (C) 2012 mbed.org, MIT License
 *
 * Permission is hereby granted, free of charge, to any person obtaining a copy of this software
 * and associated documentation files (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge, publish, distribute,
 * sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in all copies or
 * substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING
 * BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM,
 * DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
#include "Socket/Socket.h"
#include "Socket/Endpoint.h"
#include <cstring>
#include <cstdio>

// BLE network_stubs.cpp linkage
extern "C" void ble_set_remote_ip_address(const char *ipAddress,const int ipAddressLength);
extern "C" void ble_set_remote_ip_port(const int ipPort); 

Endpoint::Endpoint()  {
    reset_address();
}
Endpoint::~Endpoint() {}

void Endpoint::reset_address(void) {
    memset(_ipAddress,0,sizeof(_ipAddress));
    _ipPort = 0;
}

#include "stdio.h"

int Endpoint::set_address(const char* host, const int port) {
    reset_address();
    
    // XXX do we need to worry about hostname->ipaddress mapping for BLE?
    memcpy(_ipAddress,host,strlen(host));
    ble_set_remote_ip_address(host,strlen(host));
    
    // copy port number
    _ipPort = port;
    
    // BLE also needs it for the connection record
    ble_set_remote_ip_port(port);
    
    // return the port number...
    return port;
}

char* Endpoint::get_address() {
    return _ipAddress;
}

int   Endpoint::get_port() {
   return _ipPort;
}
