/**
 * @file    UartRPCFunctions.h
 * @brief   BLE UART RPC stubs header
 * @author  Doug Anson
 * @version 1.0
 * @see     
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
 
 #ifndef __UART_RPC_FUNCTIONS_H__
 #define __UART_RPC_FUNCTIONS_H__
 
 #include "UartRPC.h"
 
 typedef enum {
     SOCKET_OPEN_FN  = 0x01,
     SOCKET_CLOSE_FN = 0x02,
     SEND_DATA_FN    = 0x04,
     RECV_DATA_FN    = 0x08,
     GET_LOCATION_FN = 0x16,
     NUM_FNs         = 5
 } FunctionIDs;
  
 extern "C" void ble_rpc_init(BLEDevice &ble);
 extern "C" bool ble_rpc_open_udp_socket(char *ip_address,int port,ble_dispatch_callback_fn cb);
 extern "C" bool ble_rpc_close_udp_socket(void);
 extern "C" int ble_rpc_send_data(uint8_t *data,int data_length);
 extern "C" int ble_rpc_recv_packet(uint8_t *buffer,int buffer_length);
 extern "C" int ble_rpc_recv_data(uint8_t *buffer,int buffer_length);
 extern "C" int ble_rpc_get_location(BLELocation *location);
 
 #endif // __UART_RPC_FUNCTIONS_H__