/**
 * @file    BLELocation.h
 * @brief   mbed CoAP BLE BLELocation library
 * @author  Doug Anson/Chris Paola
 * @version 1.0
 * @see
 *
 * Copyright (c) 2014
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef __BLE_LOCATION_H__
#define __BLE_LOCATION_H__

// mbed API
#include "mbed.h"

// Location base class
#include "Location.h"
    
/** BLELocation class
 */
class BLELocation : public Connector::Location { 
    public:
        /**
        Constructor
        */
        BLELocation(const RawSerial *pc);
    
        /**
        Destructor
        */
        virtual ~BLELocation();
    
        /**
        Update the current location
        */
        virtual void updateLocation();
        
        /**
        Process the location update response
        */
        void processLocationUpdateResponse(char *response,int response_length);
        
        /**
        Set the default location
        */
        void setDefault(float latitude,float longitude,float altitude,float speed);
        
    private:
        void dispatchUpdateRequest();
};

#endif // __BLE_LOCATION_H__
