#include "debug.h"

// we have to redefine DBG as its used differently here...
#ifdef DBG
    #undef DBG
    #define DBG  printf
#endif

/*
 * \brief Help round function.
 *
 * \param value Divident
 * \param divider Divisor
 *
 * \return Quotient
 */
uint32_t debug_round(uint32_t value, uint32_t divider)
{
    uint32_t tmp = value;
    value *= 10;
    value /= divider;
    tmp = value;
    while(tmp > 10)
        tmp -= 10;
    if(((tmp & 0x0000000f) > 4) && ((tmp & 0x0000000f) < 10))
        value += 10;
    if(tmp != 10)
        value -= tmp;
    value /= 10;
    return value;
}

/**
 * Print a number to the debug port.
 *
 * \param width string maximum length
 * \param base base number (16 for hex, 10 for decimal etc.)
 * \param n number value
 *
 * \return pointer to the formatted string
 */
void debug_integer(uint8_t width, uint8_t base, int16_t n)
{
  uint8_t bfr[8];
  uint8_t *ptr = bfr;
  uint8_t ctr = 0;

  if (width > 7) width = 7;

  ptr += width;
  *ptr-- = 0;

  if (base == 16)
  {
      do
      {
          *ptr = n & 0x0F;
          if (*ptr < 10) *ptr += '0';
          else *ptr += ('A'-10);
          ptr--;
          n >>= 4;
          ctr++;
      }while((ctr & 1) || (ctr < width));
  }
  else
  {
      uint8_t negative = 0;
      if (n < 0)
      { negative = 1;
        n = -n;
      }
      ctr++;
      do
      {
        *ptr-- = (n % 10) + '0';
        n /= 10;
        ctr++;
      }while ((ctr < width) && n);
      if (negative)
      {
        *ptr-- = '-';
      }
      else
      {
        *ptr-- = ' ';
      }
  }
  ptr++;
  //debug_send(ptr);
  DBG((const char *)ptr);
}

/**
  * Print data array in HEX format. Bytes are separated with colon.
  *
  * \param ptr Pointer to 8-bit data array.
  * \param len Amount of printed bytes
  *
  */
void printf_array(uint8_t *ptr , uint16_t len)
{
    uint16_t i;
    for(i=0; i<len; i++)
    {
        if(i)
        {
            if(i%16== 0)
            {
                DBG("\r\n");
                if(len > 64)
                {
                    uint8_t x =254;
                    while(x--);
                }
            }
            else
            {
                DBG(":");
            }
        }
        debug_hex(*ptr++);
    }
    DBG("\r\n");
}

/**
 * Print a IPv6 address.
 *
 * \param addr_ptr pointer to ipv6 address
 *
 */
void printf_ipv6_address(uint8_t *addr_ptr)
{
    if(addr_ptr)
    {
        uint8_t i, d_colon = 0;
        uint16_t current_value = 0, last_value = 0;

        for(i=0; i< 16;i += 2)
        {
            current_value =  (*addr_ptr++ << 8);
            current_value += *addr_ptr++;

            if(i == 0)
            {
                last_value = current_value;
                debug_hex(current_value >> 8);
                debug_hex(current_value );
                DBG(":");
            }
            else
            {
                if(current_value == 0)
                {
                    if(i== 14)
                    {
                        DBG(":");
                        //debug_put('0');
                        DBG("0");
                    }
                    else
                    {
                        if(last_value == 0)
                        {
                            if(d_colon == 0)
                            {
                                d_colon=1;
                            }
                        }
                        else
                        {
                            if(d_colon == 2)
                            {
                                //debug_put('0');
                                DBG("0");
                                DBG(":");
                            }
                        }
                    }
                }
                else
                {
                    if(last_value == 0)
                    {
                        if(d_colon == 1)
                        {
                            DBG(":");
                            d_colon = 2;
                        }
                        else
                        {
                            //debug_put('0');
                            DBG("0");
                            DBG(":");
                        }
                    }
                    if(current_value > 0x00ff)
                    {
                        debug_hex(current_value >> 8);
                    }
                    debug_hex(current_value );
                    if(i< 14)
                    {
                        DBG(":");
                    }
                }
                last_value = current_value;
            }
        }
    }
    else
    {
        DBG("Address Print: pointer NULL");
    }
    DBG("\r\n");
}
