#include "mbed.h"
#include "arm_hal_timer.h"

static void (*sn_callback)(void) = NULL;
static Ticker sn_timer;
//static uint32_t sn_compare_value;
static timestamp_t sn_compare_value;
static bool timer_enabled = false;

// fix for mbed SDK v99
extern "C" uint32_t us_ticker_read(void);
 
#define MAXIMUM_SLOTS 10000
 
extern "C" void arm_timer_init(void)
{
    //init in Ticker ctor
}
 
extern "C" void arm_timer_set_cb(void (*callback)(void))
{
    sn_callback = callback;
}
 
extern "C" void arm_timer_start(uint16_t slots)
{
    sn_compare_value = slots * 50; // 1 slot = 50us
    sn_timer.attach_us(sn_callback, sn_compare_value);
    timer_enabled = true;
}
 
extern "C" void arm_timer_stop(void)
{
    sn_timer.detach();
    timer_enabled = false;
}
 
extern "C" uint16_t arm_timer_get_remaining_slots(void)
{
    uint32_t counter = us_ticker_read();
    uint32_t slots = ((sn_compare_value - counter) / 50);
 
    if ((slots > MAXIMUM_SLOTS) || (timer_enabled == false)) {
        slots = 0;
    }

    return (uint16_t)slots;
}
