/*
 * driverRFPhy.h
 *
 *  Created on: 14 July 2014
 *      Author: mBed Team
 */

#ifndef DRIVERRFPHY_H_
#define DRIVERRFPHY_H_

#include "arm_hal_phy.h"    

#ifdef __cplusplus
extern "C" {
#endif

/*Run calibration every 5 minutes*/
#define RF_CALIBRATION_INTERVAL 6000000
/*Wait ACK for 2.5ms*/
#define RF_ACK_WAIT_TIMEOUT 50

#define RF_BUFFER_SIZE 128
#define RF_DEFAULT_CHANNEL  11

/*Radio RX and TX state definitions*/
#define RFF_ON 0x01
#define RFF_RX 0x02
#define RFF_TX 0x04
#define RFF_CCA 0x08

/*Atmel RF states*/
typedef enum
{
    NOP = 0x00,
    BUSY_RX = 0x01,
    RF_TX_START = 0x02,
    FORCE_TRX_OFF = 0x03,
    FORCE_PLL_ON = 0x04,
    RX_ON = 0x06,
    TRX_OFF = 0x08,
    PLL_ON = 0x09,
    BUSY_RX_AACK = 0x11,
    SLEEP = 0x0F,
    RX_AACK_ON = 0x16,
    TX_ARET_ON = 0x19
}rf_trx_states_t;

extern void rf_ack_wait_timer_start(uint16_t slots);
extern void rf_ack_wait_timer_stop(void);
extern void rf_handle_cca_ed_done(void);
extern void rf_handle_tx_end(void);
extern void rf_handle_rx_end(void);
extern void rf_on(void);
extern void rf_receive(void);
extern void rf_poll_trx_state_change(rf_trx_states_t trx_state);
extern void rf_init(void);
extern void rf_set_mac_address(const uint8_t *ptr);
extern int8_t rf_device_register(void);
extern int8_t rf_start_cca(uint8_t *data_ptr, uint16_t data_length, uint8_t tx_handle);
extern void rf_cca_abort(void);
extern void rf_read_mac_address(uint8_t *ptr);
extern int8_t rf_read_random(void);
extern void rf_calibration_cb(void);
extern uint8_t rf_init_phy_mode(void);
extern void rf_ack_wait_timer_interrupt(void);
extern void rf_calibration_timer_interrupt(void);
extern void rf_calibration_timer_start(uint32_t slots);
extern void rf_front_end_rx_lna(void);
extern void rf_front_end_sleep(void);
static int8_t rf_interface_state_control(phy_interface_state_e new_state, uint8_t rf_channel);
static int8_t rf_extension(phy_extension_type_e extension_type,uint8_t *data_ptr);
static int8_t rf_address_write(phy_address_type_e address_type,uint8_t *address_ptr);

 #ifdef __cplusplus
}
#endif
#endif /* DRIVERRFPHY_H_ */
